package com.elitesland.tw.tw5.api.prd.my.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.math.BigDecimal;


/**
 * 远程办公申请明细
 *
 * @author wangly
 * @date 2024-06-12
 */
@Getter
@Setter
public class AbnormalWorkApplyDetailVO extends BaseViewModel implements Serializable {
    /**
     * 远程办公申请ID
     */
    @ApiModelProperty("远程办公申请ID")
    private Long applyId;
    /**
     * 月份
     */
    @ApiModelProperty("月份")
    private String workMonth;
    /**
     * 远程办公日期
     */
    @ApiModelProperty("远程办公日期")
    private LocalDate workDate;
    /**
     * 远程办公天数
     */
    @ApiModelProperty("远程办公天数")
    private BigDecimal workDays;
    /**
     * 0.5天区分上午下午 AM上午 PM下午
     */
    @ApiModelProperty("0.5天区分上午下午 AM上午 PM下午")
    private String workInterval;

    //主表数据

    /**
     * 外出申请人id
     */
    @ApiModelProperty("外出申请人id")
    private Long applyUserId;
    @UdcName(udcName = "USER", codePropName = "applyUserId")
    private String applyUserName;
    /**
     * 归属bu_id
     */
    @ApiModelProperty("归属bu_id")
    private Long orgId;
    @UdcName(udcName = "BU", codePropName = "orgId")
    private String orgName;

    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;

    /**
     * 远程办公天数
     */
    @ApiModelProperty("远程办公天数")
    private BigDecimal days;

    /**
     * 事由类型
     */
    @ApiModelProperty("事由类型")
    private String reasonType;

    /**
     * 事由ID
     */
    @ApiModelProperty("事由ID")
    private Long reasonId;
    /**
     * 事由名称
     */
    @ApiModelProperty("事由名称")
    private String reasonName;
    /**
     * 远程工作地
     */
    @ApiModelProperty("远程工作地")
    private String abnormalWorkAddr;

    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String procInstStatus;
    @UdcName(udcName = "appr_status", codePropName = "procInstStatus")
    private String procInstStatusDesc;

    /**
     * 级别
     */
    @ApiModelProperty("级别")
    private String grade;
}
