package com.elitesland.tw.tw5.api.prd.my.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemShortcutVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

@Data
public class PrdUserDataVO extends BaseViewModel {

    private Long userId;
    /**
     * 员工姓名
     */
    private String employeeName;
    /**
     * 直属上级ID
     */
    private Long parentId;
    /**
     * 上级姓名
     */
    private String parentName;
    /**
     * 公司bookId
     */
    private Long bookId;
    /**
     * 公司名称
     */
    private String companyName;
    /**
     * 员工编号
     */
    private String employeeNo;
    /**
     * 用户邮箱
     */
    private String email;
    /**
     * ticket
     */
    private String pcLoginTicket;
    /**
     * 组织ID
     */
    private Long orgId;
    /**
     * 组织名称
     */
    private String orgName;
    @ApiModelProperty("组织类型")
    private String organizationType;
    /**
     * 岗位
     */
    private String jobs;
    /**
     * 岗位名称
     */
    private String jobsName;
    /**
     * 组织角色
     */
    private List<String> orgRoles;
    /**
     * 系统角色编码
     */
    private List<String> systemRoles;
    /**
     * 我的快捷入口ids
     */
    private String shortcutIds = "";
    /**
     * 快捷入口数据
     */
    private List<PrdSystemShortcutVO> shortcutVOs;

    /**
     * 头像url
     */
    private String headCodes;
    private Object headDatas;

    /**
     * ticekt
     */
    private String ticket;

    /**
     * 系统角色
     */
    private Set<String> roleCodes;

    /**
     * 当量系数
     */
    private BigDecimal eqvaRatio = BigDecimal.ZERO;
    /**
     * 是否 启用工作流
     */
    private Boolean workflowEnabled;

    // 是否启用 启信宝
    private Boolean qxBEnabled = false;
    /**
     * p级别
     */
    private String extString1;
    private String extString2;
    private String extString3;
    private String extString4;
    private String extString5;
    private String extString6;

    @ApiModelProperty("当量余额")
    private BigDecimal totalQty;

    @ApiModelProperty("账号余额")
    private BigDecimal totalAmt;

    @ApiModelProperty("可用当量")
    private BigDecimal avalQty;

    @ApiModelProperty("额定当量")
    private BigDecimal ratedQty;

    /**
     * 主服务地
     */
    private String baseCity;

    @UdcName(udcName = "org:employee:serviceaddr", codePropName = "baseCity")
    private String baseCityName;

    /**
     * 电脑补贴额度
     */
    private String monthlyAmt;

    /**
     * 个人图标json
     */
    private String shortcutJson;
    /**
     * 个人配置图标ID
     */
    private Long userConfigIconId;

}
