package com.elitesland.tw.tw5.api.prd.my.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

@Getter
@Setter
public class TAttendanceNormalMonthVO extends BaseViewModel implements Serializable {
    /**
     * 打卡人员ID
     */
    @ApiModelProperty("打卡人员ID")
    private Long attendanceResId;

    @UdcName(udcName = "USER", codePropName = "attendanceResId")
    @ExcelProperty(value = "姓名", index = 2)
    private String userName;

    /**
     * 打卡人员部门ID
     */
    @ApiModelProperty("打卡人员部门ID")
    private Long orgId;

    @UdcName(udcName = "BU", codePropName = "orgId")
    @ExcelProperty(value = "BU", index = 3)
    private String orgName;

    /**
     * 打卡月份
     */
    @ApiModelProperty("打卡月份")
    @ExcelProperty(value = "月份", index = 1)
    private String attendanceMonth;


    /**
     * 规则ID
     */
    @ApiModelProperty("规则ID")
    private Long attendanceRuleId;

    /**
     * 规则名称
     */
    @ApiModelProperty("规则名称")
    @ExcelProperty(value = "所属规则", index = 4)
    private String ruleName;

    @ApiModelProperty("主服务地")
    private String baseCity;

    @UdcName(udcName = "org:employee:serviceaddr", codePropName = "baseCity")
    private String baseCityName;

    @ApiModelProperty("应打卡天数")
    @ExcelProperty(value = "应打卡天数", index = 5)
    private Long shouldColock; //应打卡天数

    @ApiModelProperty("正常天数")
    @ExcelProperty(value = "正常天数", index = 6)
    private Long normalDays; //正常天数

    @ApiModelProperty("异常天数")
    @ExcelProperty(value = "异常天数", index = 7)
    private Long abnormalDays;// 异常天数


    private String attendanceResultDetailStr;// 打卡状态数据

}

