package com.elitesland.tw.tw5.api.prd.my.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitesland.tw.tw5.api.udc.UdcName;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

/**
* 工时表
*
* @author duwh
* @date 2022-12-09
*/
@Data
@ExcelIgnoreUnannotated
public class TimesheetExcel {

    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    /** 填报用户id */
    private Long tsUserId;
    @ExcelProperty(index = 3, value = "填报人")
    @UdcName(udcName = "USER", codePropName = "tsUserId")
    private String tsUserIdName;
    /** 填报Bu主键 */
    private Long tsUserBuId;
    /** 填报Bu名称 */
    @ExcelProperty(index = 4, value = "部门")
    private String tsUserBuName;
    /** 状态 */
    /**
     * see TimesheetStatus
     * 状态 - T_TIMESHEET.TS_STATUS
     * TSK:TIMESHEET_STATUS	新建	CREATE
     * TSK:TIMESHEET_STATUS	审批中	APPROVING
     * TSK:TIMESHEET_STATUS	已审批	APPROVED
     * TSK:TIMESHEET_STATUS	已结算	SETTLED
     * TSK:TIMESHEET_STATUS	已退回	REJECTED
     */
    private String tsStatus;
    @ExcelProperty(index = 2, value = "状态")
    @UdcName(udcName = "prd:timesheet:status", codePropName = "tsStatus")
    private String tsStatusDesc;
    /** 类型 */
    private String type;
    /** 审批用户id */
    private Long apprUserId;
    /**
     * 审批用户姓名
     */
    @UdcName(udcName = "USER", codePropName = "apprUserId")
    private String apprUserIdName;
    /** 客户经营计划主键 */
    private Long operPlanId;
    /** 客户经营计划名称冗余 */
    @ExcelProperty(index = 9, value = "经营计划")
    private String operPlanName;
    /** 项目id */
    private Long projId;
    /** 项目编号冗余 */
    private String projNo;
    /** 项目名称 */
    @ExcelProperty(index = 5, value = "项目")
    private String projName;
    /** 任务id */
    private Long taskId;

    public Long getTaskId() {
        if(taskId == null){
            if (StringUtils.hasText(type) && type.equals("DEV_OPS")) {
                return taskId;
            }
            taskId = 0L;
        }
        return taskId;
    }

    public String getTaskName() {
        if (StringUtils.hasText(type) && type.equals("DEV_OPS")) {
            return taskName;
        }
        if(taskId == null || (taskId!=null && taskId.equals(0L))){
            return "无任务";
        }
        return taskName;
    }

    /** 任务编号冗余 */
    private String taskNo;
    /** 任务名称冗余 */
    @ExcelProperty(index = 6, value = "任务")
    private String taskName;
    /** 任务包申请状态 see TimesheetStatus  */
    private String taskApplyStatus;
    /** 活动id */
    private Long actId;
    /** 活动名称冗余 */
    @ExcelProperty(index = 7, value = "活动")
    private String actName;
    /** 活动编号冗余 */
    private String actNo;
    /** 当量 */
    private BigDecimal eqva;
    /** 11上午、22下午、33全天、44自定义 */
    private String workType;
    /** 工作日期 */
    private LocalDate workDate;

    @ExcelProperty(index = 0, value = "填报时间")
    private String workDateStr;

    public String getWorkDateStr() {
        if(null != workDate){
            return FORMATTER.format(workDate);
        }
        return workDateStr;
    }

    /** 工时 */
    private BigDecimal workHour;
    @ExcelProperty(index = 1, value = "工时")
    private String workHourStr;

    public String getWorkHourStr() {
        if (null != workHour) {
            return workHour.toString();
        }
        return workHourStr;
    }

    /** 工作说明 */
    @ExcelProperty(index = 8, value = "工作日志")
    private String workDesc;
    /** 本周开始日期 */
    private LocalDate weekStartDate;
    /** 本周结束日期 */
    private LocalDate weekEndDate;

    public LocalDate getWeekEndDate() {
        if (null != weekStartDate) {
            return weekStartDate.plusDays(7);
        }
        return weekEndDate;
    }

    /** 所在年周 */
    private Integer yearWeek;
    /** 总计人天 */
    private BigDecimal totalManday;
    /** 总计小时数 */
    private BigDecimal totalWorkHour;
    /** 审批状态 */
    private String apprStatus;
    /** 任务标识 */
    private String tsTaskIden;
    /** 活动标识 */
    private String tsActIden;
    @UdcName(udcName = "prd:timesheet:notask", codePropName = "tsActIden")
    private String tsActIdenDesc;
    /** 结算状态 */
    private String settleStatus;
    /** 审批状态 */
    private String apprResult;
    /** 是否加班、udc >> yesno */
    //private String workFlag;
    /** 可生成调休天数 */
    //private Float workDayOff;
    /** 相关加班安排id */
    //private Integer workRelId;
    /** 可生成调休天数的状态 */
    private String workDayOffStatus;
    /** 工作计划id */
    private Long workPlanId;
    /** 拓展1 */
    private String ext1;
    /** 拓展2 */
    private String ext2;
    /** 拓展3 */
    private String ext3;
    /** 拓展4 */
    private String ext4;
    /** 拓展5 */
    private String ext5;

    /**
     * 关联任务包的当量系数
     */
    private BigDecimal eqvaRatio;

    /**
     * 工时占用的任务包的当量
     */
    private BigDecimal eqvaTimeSheet;

    /**
     * 根据 当量系数 工时计算当量
     * @return
     */
    public BigDecimal getEqvaTimeSheet() {
        if(this.eqvaTimeSheet != null){
            return this.eqvaTimeSheet;
        }
        if(this.eqvaRatio != null && this.getWorkHour() != null){
            return this.eqvaRatio.multiply(this.getWorkHour()).divide(BigDecimal.valueOf(8),2, RoundingMode.DOWN);//向下取整数
        }
        return null;
    }

    private String acceptMethod;// 任务包的验收方式

    @ExcelProperty(index = 10, value = "备注")
    private String remark;

}
