package com.elitesland.tw.tw5.api.prd.my.vo;

import lombok.Data;
import lombok.Getter;

/**
 * 工作代办
 *
 * @author wwagnding
 */
@Data
public class TwRecentWorkVO {
    private String title;
    private String url;
    private Long num; //数量
    private RecentWorkType type;//类型
    private Object data;//参数或者集合数据
    private String code;

    public enum RecentWorkType {
        FEED_BACK("FEED_BACK", "问题反馈"),
        LEADS_TO_RECEIVE("LEADS_TO_RECEIVE", "线索领取"),
        LEADS_TO_DISTRIBUTE("LEADS_TO_DISTRIBUTE", "线索分配"),
        ACTIVITY_RELEASE("ACTIVITY_RELEASE", "活动待发布"),
        OPERATION_PLAN_DETAIL("OPERATION_PLAN_DETAIL", "经营计划待执行"),
        VISIT_TASK("VISIT_TASK", "待办拜访任务"),
        VISIT_TASK_EVAL("VISIT_TASK_EVAL", "待办拜访评价"),
        OPERATION_CHANCE_DETAIL("OPERATION_CHANCE_DETAIL", "经营机会点待跟踪"),
        COMFIRMED_CUSTOMER("COMFIRMED_CUSTOMER", "待确认潜在客户"),

        PROJECT_TO_CREATE("PROJECT_TO_CREATE", "项目待创建"),

        RESOURCE_PLAN_TO_UPDATE("RESOURCE_PLAN_TO_UPDATE", "资源规划待更新"),

        PROJECT_TO_BRIEF("PROJECT_TO_BRIEF", "项目汇报待提交"),
//        PROJECT_UPDATE("PROJECT_UPDATE", "项目待更新"),
        PROJECT_BUDGET_UPDATE("PROJECT_BUDGET_UPDATE", "项目预算待更新"),

        TASK_ACCEPTANCE("TASK_ACCEPTANCE", "任务待验收"),
        RECYCLE_SETTLE("RECYCLE_SETTLE", "结算单回收"),
        CONTRACT_BUDGET_PERSON_PLAN("CONTRACT_BUDGET_PERSON_PLAN","合同预算资源规划");
        ;

        @Getter
        private String desc;
        @Getter
        private String code;

        RecentWorkType(String code, String desc) {
            this.desc = desc;
            this.code = code;
        }
    }


    public static TwRecentWorkVO of(String title, RecentWorkType type, Object data) {
        TwRecentWorkVO recentWorkVO = new TwRecentWorkVO();
        recentWorkVO.setTitle(title);
        recentWorkVO.setType(type);
        recentWorkVO.setData(data);
        recentWorkVO.setNum(0L);
        return recentWorkVO;
    }

    public static TwRecentWorkVO of(String title, Long num, String code, String url) {
        TwRecentWorkVO recentWorkVO = new TwRecentWorkVO();
        recentWorkVO.setTitle(title);
        recentWorkVO.setCode(code);
        recentWorkVO.setUrl(url);
        recentWorkVO.setNum(num);
        return recentWorkVO;
    }

    public static TwRecentWorkVO of(String title, String code) {
        TwRecentWorkVO recentWorkVO = new TwRecentWorkVO();
        recentWorkVO.setTitle(title);
        recentWorkVO.setCode(code);
        recentWorkVO.setUrl("");
        recentWorkVO.setNum(0L);
        return recentWorkVO;
    }

    public static TwRecentWorkVO of(String title, Long num, String code) {
        TwRecentWorkVO recentWorkVO = new TwRecentWorkVO();
        recentWorkVO.setTitle(title);
        recentWorkVO.setCode(code);
        recentWorkVO.setUrl("");
        recentWorkVO.setNum(num);
        return recentWorkVO;
    }

    public static TwRecentWorkVO of(String title, RecentWorkType type, Object data, String url) {
        TwRecentWorkVO recentWorkVO = new TwRecentWorkVO();
        recentWorkVO.setTitle(title);
        recentWorkVO.setType(type);
        recentWorkVO.setData(data);
        recentWorkVO.setUrl(url);
        recentWorkVO.setNum(0L);
        return recentWorkVO;
    }
}
