package com.elitesland.tw.tw5.api.prd.org.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.payload.*;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgOrganizationQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.*;

import java.util.List;
import java.util.Map;

public interface PrdOrgOrganizationService {

    /**
     * 新增
     *
     * @param payload 单据数据
     */
    PrdOrgOrganizationVO insert(PrdOrgOrganizationPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     */
    Long update(PrdOrgOrganizationPayload payload);


    /**
     * 修改父组织
     *
     * @param payload 单据数据
     */
    Long updateRef(PrdOrgOrganizationRefPayload payload);

    /**
     * 组织引用
     *
     * @param payload 单据数据
     */
    Long reference(PrdOrgOrganizationRefPayload payload);


    /**
     * 组织逻辑删除
     *
     * @param dimensionId 维度id orgId 组织id
     * @return result
     */
    boolean deleteSoft(Long dimensionId, Long orgId);

    /**
     * 根据维度id组织列表查询
     *
     * @return
     */
    List<PrdOrgOrganizationRefVO> queryList(Long dimensionId);


    /**
     * 查询所有组织
     *
     * @return
     */
    List<PrdOrgOrganizationRefVO> queryList();


    /**
     * 全部组织查询
     *
     * @return
     */
    List<PrdOrgOrganizationRefVO> queryAll(Long dimensionId, Boolean defaultFlag);

    List<PrdOrgOrganizationVO> queryAllByQuery(PrdOrgOrganizationQuery query);

    /**
     * 根据组织状态查询所有可用组织
     *
     * @param orgStatus 组织状态
     * @return
     */
    List<PrdOrgOrganizationRefVO> queryByOrgStatus(String orgStatus);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<PrdOrgOrganizationVO> paging(PrdOrgOrganizationQuery query);

    /**
     * 根据组织id查询员工数据
     *
     * @return
     */
    List<PrdOrgEmployeeRefVO> queryEmployeeRefList(Long orgId);

    /**
     * 根据主键组织详情查询
     *
     * @param dimensionId 维度id orgId 组织id
     * @return
     */
    PrdOrgOrganizationVO queryDetail(Long dimensionId, Long orgId);

//    /**
//     * 根据主键组织详情查询
//     *
//     * @param id 主键
//     * @return
//     */
//    PrdOrgOrganizationVO queryOrgById(Long id);

    /**
     * 查询部门角色
     *
     * @param orgId
     * @param code
     * @return
     */
    PrdOrgRoleVO queryRoleByOrgIdAndRoleCode(Long orgId, String code);

    /**
     * 根据主键查询
     *
     * @param orgId org id
     * @return {@link PrdOrgOrganizationVO}
     */
    PrdOrgOrganizationVO queryDetailSimpleByOrgId(Long orgId);

    /**
     * 添加组织员工
     *
     * @return
     */
    Long insertEmployeeRef(List<PrdOrgEmployeeRefPayload> payloads);

    /**
     * 移除组织员工
     *
     * @return
     */
    boolean deleteEmployeeRefSoft(Long orgId, List<Long> employeeIds);

    /**
     * 添加组织角色
     *
     * @return
     */
    PrdOrgRoleVO insertRole(PrdOrgRolePayload payload);

    /**
     * 修改组织角色
     *
     * @param payload 单据数据
     */
    Long updateRole(PrdOrgRolePayload payload);

    /**
     * 删除组织角色
     *
     * @param key 主键
     */
    Boolean deleteRoleSoft(Long key);

    /**
     * 组织状态修改
     *
     * @param id 主键 orgStatus状态
     */
    Long updateStatus(Long id, String orgStatus);

    /**
     * 组织关系更改
     *
     * @param payloads
     */
    Long updateOrgOrEmpRef(List<PrdOrgOrganizationDataPayload> payloads);


    Map<Long, String> queryOrgs(List<Long> asList);

    Map<Long, Long> getV4AndV5OrgIds();

    /**
     * 员工组织关系列表
     *
     * @return
     */
    List<PrdOrgDataRefVO> queryOrgRefList();

    /**
     * 组织角色列表
     *
     * @return
     */
    List<PrdOrgRoleVO> queryRoleList();

    /**
     * 查询该资源作为组织负责人所在的所有组织id
     *
     * @param userId
     * @return
     */
    List<Long> queryByManageIdOrgIds(Long userId);

    /**
     * 查询改资源作为组织负责人所在的组织
     *
     * @param userId
     * @return
     */
    List<PrdOrgOrganizationVO> queryByManageIdOrgs(Long userId);

    /**
     * 根据维度id组织列表及角色数据
     *
     * @return
     */
    List<PrdOrgOrganizationRefVO> queryOrgRoleList(Long dimensionId);

    /**
     * 根据维度id查询角色数据
     *
     * @param dimensionId
     * @return
     */
    List<PrdOrgRoleVO> queryRolesByDimensionId(Long dimensionId);

    /**
     * 根据用户id查询角色列表
     *
     * @param userId
     * @return
     */
    List<PrdOrgRoleVO> queryUserOrgRoles(Long userId);

    /**
     * 查询组织负责人
     *
     * @return
     */
    Long queryManageIdById(Long id);

    /**
     * 查询某个人下面的所有子组织(这个人需要是组织负责人)
     *
     * @return
     */
    List<PrdOrgOrganizationRefVO> queryAllChildOrgByUserId(Long userId);


    /**
     * 查询某个组织下面的所有子组织(这个人需要是组织负责人)
     *
     * @return
     */
    List<PrdOrgOrganizationRefVO> queryAllChildOrgByOrgId(Long orgId);

    /**
     * 查询某个组织上面的所有父组织
     *
     * @return
     */
    List<PrdOrgOrganizationRefVO> queryAllFatherOrgByOrgId(Long orgId);

    /**
     * 查询某个人所在组织ids及所有子组织ids
     *
     * @return
     */
    List<Long> queryAllOrgIdsByUserId(Long userId);

    /**
     * 判断当前登录人与部门及子部门的包含关系
     *
     * @param userId
     * @param orgIds
     * @return
     */
    Boolean containCheck(Long userId, String orgIds);
}
