package com.elitesland.tw.tw5.api.prd.org.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 员工当量系数
 *
 * @author 王顶
 * @date 2022/11/03
 */
@Data
public class PrdOrgEmployeeEqvaRatioVO extends BaseViewModel implements Comparable<PrdOrgEmployeeEqvaRatioVO>{

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("4.0的当前当量系数记录id")
    private Long eqvaRatioIdV4;

    @ApiModelProperty("组织id")
    private Long orgId;


    @ApiModelProperty("用户id")
    private Long userId;


    @ApiModelProperty("开始日期")
    private LocalDate startDate;


    @ApiModelProperty("结束日期")
    private LocalDate endDate;


    @ApiModelProperty("当量系数")
    private BigDecimal eqvaRatio;

    @Override
    public int compareTo(PrdOrgEmployeeEqvaRatioVO o) {
        //开始时间从晚到早排序
        return o.startDate.compareTo(this.startDate);
    }
}
