package com.elitesland.tw.tw5.api.prd.org.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;

@Data
public class PrdOrgPersonVO extends BaseViewModel {

    @ApiModelProperty("姓名")
    private String personName;

    @ApiModelProperty("审批状态")
    private String apprStatus;
    @UdcName(udcName = "appr_status", codePropName = "apprStatus")
    private String apprStatusName;

    @ApiModelProperty("性别")
    private String sex;

    @ApiModelProperty("用户账号")
    private String userName;

    @ApiModelProperty("手机号")
    private String mobile;

    @ApiModelProperty("是否启用")
    private Boolean enabled;

    @ApiModelProperty(value = "用户邮箱地址")
    private String email;

    @ApiModelProperty("外文名")
    private String foreignName;

    @ApiModelProperty("证件类型")
    private String idType;

    @ApiModelProperty("证件号码")
    private String idNo;

    @ApiModelProperty("证件开始日")
    private LocalDate idValidFrom;

    @ApiModelProperty("证件到期日")
    private LocalDate idValidTo;

    @ApiModelProperty("证件url")
    private String idValidCodes;
    private Object idValidDatas;

    @ApiModelProperty("头像url")
    private String headCodes;
    private Object headDatas;

    @ApiModelProperty("生日")
    private LocalDate birthday;

    @ApiModelProperty("国籍")
    private String nationality;

    @ApiModelProperty("籍贯")
    private String birthplace;

    @ApiModelProperty("民族")
    private String nation;

    @ApiModelProperty("婚姻状况")
    private Integer marital;

    @ApiModelProperty("通讯地址")
    private String addr;

    @ApiModelProperty("紧急联系人")
    private String urgency_name;

    @ApiModelProperty("手机号")
    private String urgency_mobile;

    @ApiModelProperty("关系")
    private String urgency_ref;

    @ApiModelProperty("排序")
    private Integer sortIndex;

    @ApiModelProperty("是否员工")
    private Boolean employeeFlag;

    @ApiModelProperty("自我评价")
    private String selfEvaluation;

    @ApiModelProperty("个人简历url")
    private String resumeCodes;
    private Object resumeDatas;

    @ApiModelProperty("自我介绍视频url")
    private String selfIntroVideoCodes;
    private Object selfIntroVideoDatas;

    @ApiModelProperty("标签")
    private String selfTagging;

    @ApiModelProperty("专业技能&专业领域")
    private String professionalSkills;

    @ApiModelProperty("从业年限")
    private String professionalYears;

//    public String getApprStatusDesc() {
//        if (null == apprStatus) {
//            return "";
//        }
//        return apprStatus.getDesc();
//    }

    @ApiModelProperty("人才状态")
    private String resourceStatus;
    @UdcName(udcName = "org:employee:resource", codePropName = "resourceStatus")
    private String resourceStatusName;
    
}
