package com.elitesland.tw.tw5.api.prd.partner.business.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 业务合作伙伴-企业主要人员
 *
 * @author wangly
 * @date 2023-05-18
 */
@Getter
@Setter
public class BusinessOperationEmployeesQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 地址簿id 精确 */
    @ApiModelProperty("地址簿id")
    private Long bookId;
    /** 主要人员姓名 精确 */
    @ApiModelProperty("主要人员姓名")
    private String name;
    /** 主要人员职位 精确 */
    @ApiModelProperty("主要人员职位")
    private String title;
    /** 是否历史，是否历史；0：否1：是 精确 */
    @ApiModelProperty("是否历史，是否历史；0：否1：是")
    private Integer isHistory;
    /** 业务伙伴主键 business_partner.id 精确 */
    @ApiModelProperty("业务伙伴主键 business_partner.id")
    private Long partnerId;
    /** 业务伙伴名称 */
    @ApiModelProperty("业务伙伴名称")
    private String partnerName;
}
