package com.elitesland.tw.tw5.api.prd.partner.business.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.business.payload.BusinessOperationEmployeesPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.query.BusinessOperationEmployeesQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.BusinessOperationEmployeesVO;

import java.util.List;

/**
 * 业务伙伴-企业主要人员
 *
 * @author wangly
 * @date 2023-05-16
 */
public interface BusinessOperationEmployeesService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessOperationEmployeesVO}>
     */
    PagingVO<BusinessOperationEmployeesVO> queryPaging(BusinessOperationEmployeesQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessOperationEmployeesVO}>
     */
    List<BusinessOperationEmployeesVO> queryListDynamic(BusinessOperationEmployeesQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessOperationEmployeesVO}
     */
    BusinessOperationEmployeesVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessOperationEmployeesVO}
     */
    BusinessOperationEmployeesVO insert(BusinessOperationEmployeesPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessOperationEmployeesVO}
     */
    BusinessOperationEmployeesVO update(BusinessOperationEmployeesPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 通过partnerId删除
     *
     * @param partnerId 业务伙伴id
     */
    void deleteByPartnerId(Long partnerId);
}
