package com.elitesland.tw.tw5.api.prd.partner.common.payload;

import lombok.Data;

/**
 * @author wly
 * @Description:地址簿管理
 */

@Data
public class PrdAbPayload {

    /**
     * 4.0的客户id
     */
    private Long id;
    /**
     * 4.0地址簿id
     */
    private Long bookId;
    /**
     * 地址簿编号
     */
    private String bookNo;
    /**
     * 客户状态(激活，暂挂)
     */
    private String customerStatus;
    /**
     * 客户名称
     */
    private String customerName;
    /**
     * 客户级别
     */
    private String customerGrade;

    /**
     * 客户来源
     */
    private String customerSource;
    /**
     * 客户行业
     */
    private String companyIndustry;

    /**
     * 电话
     */
    private String companyPhone;

    /**
     * 邮箱
     */
    private String companyEmail;

    /**
     * 传真
     */
    private String companyFax;
    /**
     * 省
     */
    private String province;
    /**
     * 省
     */
    private String provinceName;
    /**
     * 市
     */
    private String city;
    /**
     * 市
     */
    private String cityName;
    /**
     * 区
     */
    private String district;
    /**
     * 区
     */
    private String districtName;
    /**
     * 详细地址
     */
    private String companyAddress;

    /**
     * 网址
     */
    private String companyWebsite;
    /**
     * 规模
     */
    private String companyScale;
    /**
     * 税号
     */
    private String taxNo;
    /**
     * 交易货币
     */
    private String currency;
    /**
     * 语言
     */
    private String language;
    /**
     * 公司性质
     */
    private String companyNature;

    /**
     * 服务负责人
     */
    private Long serviceUserId;
    /**
     * 商务负责人
     */
    private Long businessUserId;

    /**
     * 关怀负责人
     */
    private Long careUserId;

    /**
     * 运维售后负责人
     */
    private Long operationUserId;

    /**
     * 修改类型：0修改，1变更负责人
     */
    private Integer updateType = 0;

    /**
     * 备注
     */
    private String remark;

    /**
     * 删除标志
     */
    private Integer deleteFlag;

    /**
     * 地址簿数据类型（01 客户 02 供应商）
     */
    private String relateType;

    /**
     * 地址簿类型（01 个人 02 公司 03 bu）
     */
    private String abType;

    /**
     * 客户新增标志 1是 0 否
     */
    private Boolean customerAddFlag = false;

    /**
     * 供应商新增标志 1是 0 否
     */
    private Boolean supplierAddFlag = false;
}
