package com.elitesland.tw.tw5.api.prd.partner.common.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookContactsPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookContactsQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookContactsVO;

import java.util.List;

/**
 * 业务伙伴-联系信息
 *
 * @author wangly
 * @date 2023-05-16
 */
public interface BookContactsService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BookContactsVO}>
     */
    PagingVO<BookContactsVO> queryPaging(BookContactsQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BookContactsVO}>
     */
    List<BookContactsVO> queryListDynamic(BookContactsQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BookContactsVO}
     */
    BookContactsVO queryByKey(Long key);

    /**
     * 根据bookId查询默认
     *
     * @param bookId bookId
     * @return {@link BookContactsVO}
     */
    BookContactsVO queryDefaultByBookId(Long bookId);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @param logFlag 是否需要操作记录日志
     * @return {@link BookContactsVO}
     */
    BookContactsVO insert(BookContactsPayload payload, Boolean logFlag);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @param logFlag 是否需要操作记录日志
     * @return {@link BookContactsVO}
     */
    BookContactsVO update(BookContactsPayload payload,Boolean logFlag);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys,Long bookId,Long partnerId,Boolean logFlag);

    /**
     * 查询联系信息列表
     *
     * @return {@link List}<{@link BookContactsVO}>
     */
    List<BookContactsVO> listSimple();

    /**
     * 查询数量
     *
     * @param query 单据数据
     * @return Long 条数
     */

    Long count(BookContactsQuery query);
//    /**
//     * 4.0同步联系人信息查询
//     *
//     * @param bookIdList
//     * @return Long 条数
//     */
//
//    List<PrdAbContactsPayload> queryTwBookContactsListByBookId(List<Long> bookIdList);
}
