package com.elitesland.tw.tw5.api.prd.partner.common.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookLicensePayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookLicenseQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookLicenseVO;

import java.util.List;

/**
 * 公司主体-证件信息
 *
 * @author wangly
 * @date 2023-05-29
 */
public interface BookLicenseService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BookLicenseVO}>
     */
    PagingVO<BookLicenseVO> queryPaging(BookLicenseQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BookLicenseVO}>
     */
    List<BookLicenseVO> queryListDynamic(BookLicenseQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BookLicenseVO}
     */
    BookLicenseVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BookLicenseVO}
     */
    BookLicenseVO insert(BookLicensePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BookLicenseVO}
     */
    BookLicenseVO update(BookLicensePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
