package com.elitesland.tw.tw5.api.prd.partner.common.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessParnerTaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessPartnerChangePayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessPartnerPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.CommonKeysPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BusinessPartnerQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.*;

import java.util.List;
import java.util.Map;

/**
 * 业务伙伴管理
 *
 * @author wangluyu
 * @date 2023-05-16
 */
public interface BusinessPartnerService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessPartnerVO}>
     */
    PagingVO<BusinessPartnerVO> queryPaging(BusinessPartnerQuery query);

    /**
     * 统计数据
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessPartnerVO}>
     */
    long count(BusinessPartnerQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessPartnerVO}>
     */
    List<BusinessPartnerVO> queryListDynamic(BusinessPartnerQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessPartnerVO}
     */
    BusinessPartnerVO queryByKey(Long key);

    /**
     * 通过bookId查询
     *
     * @param bookId 地址簿id
     * @return {@link BusinessPartnerVO}
     */
    List<BusinessPartnerVO> queryByBookId(Long bookId);

    /**
     * 通过bookId查询客户数据
     *
     * @param bookId 地址簿id
     * @return {@link BusinessPartnerVO}
     */
    BusinessPartnerVO queryCustomerByBookId(Long bookId);

    /**
     * 通过bookId查询供应商数据
     *
     * @param bookId 地址簿id
     * @return {@link BusinessPartnerVO}
     */
    BusinessPartnerVO querySupplierByBookId(Long bookId);
    /**
     * 查询通过合作伙伴名称
     *
     * @param partnerName 合作伙伴名称
     * @return {@link BusinessPartnerSimpleVO}
     */
    BusinessPartnerSimpleVO queryByPartnerName(String partnerName);

    /**
     * 简单查询
     *
     * @param key 关键
     * @return {@link BusinessPartnerVO}
     */
    BusinessPartnerVO queryByKeySimple(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessPartnerVO}
     */
    BusinessPartnerVO insert(BusinessPartnerPayload payload);


    /**
     * 新增其他身份
     *
     * @param payload                单据数据
     * @param operationLogRecordFlag 是否记录日志
     * @return {@link BusinessPartnerVO}
     */
    BusinessPartnerVO insertOtherIdentity(BusinessPartnerPayload payload, Boolean operationLogRecordFlag);

    /**
     * 新增
     *
     * @param payload                单据数据
     * @param checkPartnerNameFlag   是否校验业务伙伴名称重复
     * @param qixinFlag              是否启用启信宝功能
     * @param operationLogRecordFlag 是否记录操作记录
     * @return {@link BusinessPartnerVO}
     */
    BusinessPartnerVO insertPro(BusinessPartnerPayload payload, boolean checkPartnerNameFlag, boolean qixinFlag, boolean operationLogRecordFlag);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessPartnerVO}
     */
    BusinessPartnerVO update(BusinessPartnerPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 查询业务伙伴母公司下拉列表
     */
    List<BusinessPartnerSimpleVO> queryListSimple();


    /**
     * 查询业务伙伴母公司下拉列表
     */
    List<BusinessPartnerSimpleVO> queryNearCustomerList();

    /**
     * 业务伙伴名称重复性校验
     *
     * @param partnerName 业务伙伴名称
     */
    void judgePartnerName(String partnerName);

    /**
     * 通过id查询业务伙伴列表
     *
     * @param ids id list
     * @return {@link List}<{@link BusinessPartnerVO}>
     */
    List<BusinessPartnerVO> queryListByIds(List<Long> ids);

    /**
     * 通过id查询身份部分哪些标签需要展示
     *
     * @param partnerId 合作伙伴id
     * @return {@link List}<{@link BusinessPartnerIdentityVO}>
     */
    BusinessPartnerIdentityVO judgeIdentityDisplay(Long partnerId);

    /**
     * 组织树
     *
     * @param query 查询
     * @return {@link List}<{@link BusinessPartnerTreeVO}>
     */
    List<BusinessPartnerTreeVO> listTree(BusinessPartnerQuery query);

    /**
     * 销售线索统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    long saleCount(BusinessPartnerQuery query);

    /**
     * 特殊查询
     *
     * @param partnerNameList 合作伙伴名单
     * @return {@link List}<{@link BusinessPartnerVO}>
     */
    List<BusinessPartnerVO> listForDm(List<String> partnerNameList);

    /**
     * 客户下拉查询
     */
    List<BusinessPartnerVO> queryCustPartnerListSimple();

    /**
     * 通过业务伙伴名称查询对应的详情 客户 供应商 合作伙伴
     */
    BusinessPartnerInfoVO queryBusinessPartnerInfoByPartnerName(String partnerName);

    /**
     * 业务伙伴管理-银行账户/开票信息变更
     */
    void changeAccountAndInvoice(BusinessPartnerChangePayload payload);

    /**
     * 业务伙伴管理-银行账户/开票信息变更更新
     */
    void changeAccountAndInvoiceUpdate(BusinessPartnerChangePayload payload);

    /**
     * 业务伙伴管理-银行账户/开票信息变更详情查询
     */
    BusinessPartnerChangeVO queryChangeAccountAndInvoiceInfo(Long key, Long partnerId);

    /**
     * 任务详情查询
     */
    BusinessPartnerTaskVO businessPartnerTaskInfo(BusinessParnerTaskInfoPayload payload);

    /**
     * 银行信息/开票信息审批完成更新数据
     */
    void updateAccAndInvoice(BusinessPartnerChangeVO vo);

    /**
     * 待确认潜在客户查询
     */
    PagingVO<BusinessConfirmedCustomerVO> queryConfirmedCustomer(BusinessPartnerQuery query);

    /**
     * 待确认潜在客户统计
     */
    Long countConfirmedCustomer();

    /**
     * 待确认潜在客户更新
     */
    void updateConfirmedCustomer(CommonKeysPayload payload);

    /**
     * 客户主档同步
     */
//    @Deprecated
//    void businessPartnerSync(String param);
    /**
     * 更新业务伙伴表的修改时间 方便数据同步4.0
     */
    @Deprecated
    void updateBusinessParnerModifyTime(List<Long> bookIdList);

    /**
     * 根据bookId返回Map集合 key：bookId value：业务伙伴名称
     *
     * @param bookIdList 地址薄Id
     * @return map集合
     */
    Map<Long, String> findNameByBookIds(List<Long> bookIdList);

    /**
     * 根据BookId返回信息
     *
     * @param bookIdList 地址簿Id
     * @return result
     */
    List<BusinessPartnerListInfoVO> findListInfoByBookIds(List<Long> bookIdList);

    /**
     * 根据bookId集合和类型查询
     *
     * @param bookIds
     * @param insideOrOutside
     * @return
     */
    List<BusinessPartnerVO> queryByBookIdsAndType(List<Long> bookIds, String insideOrOutside);

    /**
     * 根据合同的custId(bookId)查询合同数量
     *
     * @return
     */
    int queryContractNum(Long custId);
    /**
     * 查询客户下面的线索和商机的跟进记录
     *
     * @return
     */
    List<CrmFollowVO> queryFollowList(Long customerId, Boolean withAcitityFollows);

    void updateAccAndInvoice2(BusinessPartnerChangeVO vo);

    /**
     * 校验是否存在开票信息- 根据BookId校验该客户是否有开票信息或正在流转的客户激活流程或客户变更流程
     * @param bookId
     * @return
     */
    Boolean checkExitInvices(Long bookId);
}
