package com.elitesland.tw.tw5.api.prd.partner.common.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@Data
@ExcelIgnoreUnannotated
public class BusinessPartnerExportVO implements Serializable {

    /**
     * 业务伙伴编号
     */
    @ApiModelProperty("业务伙伴编号")
    @ExcelProperty(value = "业务伙伴编号", index = 0)
    private String businessPartnerNo;

    /**
     * 业务伙伴名称
     */
    @ApiModelProperty("业务伙伴名称")
    @ExcelProperty(value = "业务伙伴名称", index = 1)
    private String partnerName;

    /**
     * 第三方系统编号
     */
    @ApiModelProperty("第三方系统编号")
    @ExcelProperty(value = "JDE编号", index = 2)
    private String thirdSystemNo;


    /**
     * 内部/外部
     */
    @ApiModelProperty("内部/外部")
    @ExcelProperty(value = "内部/外部", index = 3)
    private String insideOrOutSideDesc;

    /**
     * 业务伙伴身份 udc[CRM:BUSINESS_PARTNER:IDENTITY]
     */
    @ApiModelProperty("业务伙伴身份描述 udc[CRM:BUSINESS_PARTNER:IDENTITY]")
    @ExcelProperty(value = "伙伴身份", index = 4)
    private String partnerIdentityDesc;


    /**
     * 客户状态 udc[CRM:BUSINESS_PARTNER:STATUS]
     */
    @ApiModelProperty("客户状态 udc[CRM:BUSINESS_PARTNER:STATUS]")
    @ExcelProperty(value = "客户状态", index = 5)
    private String customerStatusDesc;

    /**
     * 合作伙伴状态
     */
    @ApiModelProperty("合作伙伴状态")
    @ExcelProperty(value = "合作伙伴状态", index = 6)
    private String collaborateStatusDesc;

    /**
     * 供应商状态
     */
    @ApiModelProperty("供应商状态")
    @ExcelProperty(value = "供应商状态", index = 7)
    private String supplierStatusDesc;

    /**
     * 行业 udc[crm:leads_customer_industry]
     */
    @ApiModelProperty("行业 udc[crm:leads_customer_industry]")
    private String partnerIndustry;

    /**
     * 行业 udc[crm:leads_customer_industry]
     */
    @ApiModelProperty("行业描述 udc[crm:leads_customer_industry]")
    @ExcelProperty(value = "行业", index = 8)
    private String partnerIndustryDesc;

    @ApiModelProperty("省/市/区")
    @ExcelProperty(value = "省市区", index = 9)
    private String address;

    /**
     * 邮箱
     */
    @ApiModelProperty("邮箱")
    @ExcelProperty(value = "邮箱", index = 10)
    private String partnerEmail;
    /**
     * 电话
     */
    @ApiModelProperty("电话")
    @ExcelProperty(value = "电话", index = 11)
    private String partnerPhone;

    /**
     * 省
     */
    @ApiModelProperty("省")
    private String provinceName;
    /**
     * 市
     */
    @ApiModelProperty("市")
    private String cityName;
    /**
     * 区
     */
    @ApiModelProperty("区")
    private String districtName;

    @ApiModelProperty("记录创建者")
    @ExcelProperty(value = "创建人", index = 12)
    private String creatUserName;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("创建时间")
    @ExcelProperty(value = "创建时间", index = 13)
    private String createTimeString;

    public String getCreateTimeString() {
        if (createTime != null) {
            return createTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        return createTimeString;
    }

}
