package com.elitesland.tw.tw5.api.prd.partner.common.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

/**
 * 业务伙伴管理-身份标签是否展示 以及客户的数量
 *
 * @author wangluyu
 * @date 2023-05-16
 */
@Getter
@Setter
public class BusinessPartnerIdentityVO {

    @ApiModelProperty("业务往来数量")
    private List<IdentityVO> operation;

    @ApiModelProperty("业务往来数量")
    private Long businessCount = 0L;

    @ApiModelProperty("经营往来数量")
    private Long operationCount = 0L;

    @ApiModelProperty("经计划数量")
    private Long operationPlanCount = 0L;

    @ApiModelProperty("机会点数量")
    private Long operationChanceCount = 0L;

    @ApiModelProperty("银行账户数量")
    private Long accountCount = 0L;

    @ApiModelProperty("地址信息数量")
    private Long addressCount = 0L;

    @ApiModelProperty("联系信息数量")
    private Long contactCount = 0L;

    @ApiModelProperty("开票信息数量")
    private Long invoiceCount = 0L;

    @ApiModelProperty("团队成员数量")
    private Long teamCount = 0L;

    @Getter
    @Setter
    @NoArgsConstructor
    @AllArgsConstructor
    public  class IdentityVO{
        private String name;
        private String value;
        private  Boolean canEdit = false;
    }

}
