package com.elitesland.tw.tw5.api.prd.partner.common.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@Data
@ExcelIgnoreUnannotated
public class BusinessPartnerIndividualExportVO implements Serializable {


    /**
     * 业务伙伴编号
     */
    @ApiModelProperty("业务伙伴编号")
    @ExcelProperty(value = "业务伙伴编号", index = 0)
    private String businessPartnerNo;

    /**
     * 业务伙伴名称
     */
    @ApiModelProperty("业务伙伴名称")
    @ExcelProperty(value = "业务伙伴名称", index = 1)
    private String partnerName;

    /**
     * JDE编号
     */
    @ApiModelProperty("JDE编号")
    @ExcelProperty(value = "JDE编号", index = 2)
    private String thirdSystemNo;

    /**
     * 内部/外部
     */
    @ApiModelProperty("内部/外部")
    @ExcelProperty(value = "内部/外部", index = 3)

    private String insideOrOutSideDesc;

    /**
     * 业务伙伴身份 udc[CRM:BUSINESS_PARTNER:IDENTITY]
     */
    @ApiModelProperty("业务伙伴身份描述 udc[CRM:BUSINESS_PARTNER:IDENTITY]")
    @ExcelProperty(value = "伙伴身份", index = 4)
    private String partnerIdentityDesc;

    /**
     * 性别 udc[org:employee:sex]
     */
    @ApiModelProperty("性别 udc[org:employee:sex]")
    @ExcelProperty(value = "性别", index = 5)
    private String partnerSexDesc;

    /**
     * 联系人手机
     */
    @ApiModelProperty("联系人手机")
    @ExcelProperty(value = "联系人手机", index = 6)
    private String contactsPhone;

    /**
     * 联系人邮箱
     */
    @ApiModelProperty("联系人邮箱")
    @ExcelProperty(value = "联系人邮箱", index = 7)
    private String contactsEmail;

    @ApiModelProperty("记录创建者")
    @ExcelProperty(value = "创建人", index = 8)
    private String creatUserName;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("创建时间")
    @ExcelProperty(value = "创建时间", index = 9)
    private String createTimeString;

    public String getCreateTimeString() {
        if (createTime != null) {
            return createTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        return createTimeString;
    }
}
