package com.elitesland.tw.tw5.api.prd.partner.common.vo;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serializable;
import java.time.LocalDate;

@Getter
@Setter
public class BusinessPartnerTranslateVO extends BaseModel implements Serializable {

    /** 地址簿id 用来和银行账户 基本信息 地址信息等关联 */
    @ApiModelProperty("地址簿id 用来和银行账户 基本信息 地址信息等关联")
    private Long bookId;

    /** 地址簿id 用来和银行账户 基本信息 地址信息等关联 */
    @ApiModelProperty("tw4.0地址薄ID")
    private Long bookIdV4;

    /** 业务伙伴编号 */
    @ApiModelProperty("业务伙伴编号")
    private String businessPartnerNo;

    /** 类型 udc[CRM:BUSINESS_PARTNER:TYPE] */
    @ApiModelProperty("业务伙伴类型  个人/公司")
    @Column()
    private String partnerType;

    /** 业务伙伴名称 */
    @ApiModelProperty("业务伙伴名称")
    private String partnerName;

    /** 业务伙伴名称拼音 */
    @ApiModelProperty("业务伙伴名称拼音")
    private String partnerNamePinyin;

    /** 业务伙伴身份 udc[CRM:BUSINESS_PARTNER:IDENTITY] */
    @ApiModelProperty("业务伙伴身份")
    private String partnerIdentity;

    /** 行业 udc[crm:leads_customer_industry] */
    @ApiModelProperty("行业 udc[crm:leads_customer_industry]")
    private String partnerIndustry;

    /** 性质 udc[cCRM:BUSINESS_PARTNER:NATURE] */
    @ApiModelProperty("性质 udc[crm:company_nature]")

    private String partnerNature;

    /** 组织规模 udc[crm:customer_scale] */
    @ApiModelProperty("组织规模 udc[crm:customer_scale]")
    private String organizationScale;

    /** 业务伙伴区域 */
    @ApiModelProperty("业务伙伴区域")
    private String partnerRegion;

    /** 网址 */
    @ApiModelProperty("网址")
    private String partnerWebsite;

    /** 邮箱 */
    @ApiModelProperty("邮箱")
    private String partnerEmail;

    /** 传真 */
    @ApiModelProperty("传真")
    private String partnerFax;

    /** 电话 */
    @Comment("电话")
    private String partnerPhone;

    /** 主交易货币  udc[SYSTEM_BASIC:CURRENCY] */
    @Comment("主交易货币(币种)")
    @Column()
    @FieldUpdateLog(fieldName = "主交易货币", selectionKey = "SYSTEM_BASIC:CURRENCY")
    @FieldCreateLog(fieldName = "主交易货币", selectionKey = "SYSTEM_BASIC:CURRENCY")
    private String currency;

    /** 主要语言 */
    @ApiModelProperty("主要语言")
    private String language;

    /** 英文名称 */
    @ApiModelProperty("英文名称")
    private String englishName;

    /** 证件类型 */
    @ApiModelProperty("个人证件类型 udc[CRM:BUSINESS_PARTNER:CERTIFICATE_TYPE]")
    private String certificateType;

    /** 证件号 */
    @ApiModelProperty("证件号")
    private String certificateNo;


    /** 性别 udc[org:employee:sex] */
    @ApiModelProperty("性别 udc[org:employee:sex]")
    private String partnerSex;

    /** 生日 */
    @ApiModelProperty("生日")
    private String partnerBirthday;

    /** 国籍 */
    @ApiModelProperty("国籍")
    private String nationality;

    /** 籍贯 */
    @ApiModelProperty("籍贯")
    private String nativePlace;

    /** 民族 */
    @ApiModelProperty("民族")
    private String nation;

    /** 婚姻状况 */
    @ApiModelProperty("婚姻状况")
    private String maritalStatus;

    /** 证件有效期 */
    @ApiModelProperty("证件有效期起")
    private LocalDate certificateDateStart;

    /** 证件有效期 */
    @ApiModelProperty("证件有效期止")
    private LocalDate certificateDateEnd;

    /** 母公司ID */
    @ApiModelProperty("母公司ID")
    private Long parentId;

    /** 数据迁移标志 */
    @ApiModelProperty("数据迁移标志 当是更新接口且第三方系统编号为空时 需要通过partnerName去查询数据然后返回第三方系统编号")
    private Boolean dataTransferFlag;

    /** 第三方系统编号 */
    @ApiModelProperty("第三方系统编号")
    private String thirdSystemNo;

}
