package com.elitesland.tw.tw5.api.prd.partner.identity.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 业务伙伴-合作伙伴
 *
 * @author wangly
 * @date 2023-05-16
 */
@Getter
@Setter
public class BusinessCollaboratePartnerInfoPayload extends TwCommonPayload  implements Serializable {
    /** 业务伙伴主键 business_partner.id */
    @ApiModelProperty("业务伙伴主键 business_partner.id")
    private Long partnerId;
    /** 合作状态 udc[CRM:BUSINESS_PARTNER:STATUS] */
    @ApiModelProperty("合作状态 udc[CRM:BUSINESS_PARTNER:STATUS]")
    private String collaborateStatus;
    /** 合作形式 */
    @ApiModelProperty("合作形式")
    private String collaborateForm;
    /** 合作等级 udc[crm:customer_grade] */
    @ApiModelProperty("合作等级 udc[crm:customer_grade]")
    private String collaborateGradle;
    /** 合作产品 */
    @ApiModelProperty("合作产品")
    private String collaborateProduct;
    /** 合作开始时间 */
    @ApiModelProperty("合作开始时间")
    private LocalDate startTime;
    /** 合作结束时间 */
    @ApiModelProperty("合作结束时间")
    private LocalDate endTime;
    /** 合作期间说明 */
    @ApiModelProperty("合作期间说明")
    private String collaborateDescription;
    /** 产品介绍附件 */
    @ApiModelProperty("产品介绍附件")
    private String fileCodes1;
    /** 合作协议附件 */
    @ApiModelProperty("合作协议附件")
    private String fileCodes2;
    /** 扩展字段1 */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /** 扩展字段2 */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /** 扩展字段3 */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /** 扩展字段4 */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /** 扩展字段5 */
    @ApiModelProperty("扩展字段5")
    private String ext5;

    /** 合作类别 udc[CRM:BUSINESS_PARTNER:COLLABORATE_TYPE] 精确 */
    @ApiModelProperty("合作类别 udc[CRM:BUSINESS_PARTNER:COLLABORATE_TYPE]")
    private String collaborateType;
    /** 伙伴服务行业 精确 */
    @ApiModelProperty("伙伴服务行业")
    private String collaborateServiceIndustry;
    /** 服务典型客户 精确 */
    @ApiModelProperty("服务典型客户")
    private String collaborateCustomer;
    /** 服务客户规模 精确 */
    @ApiModelProperty("服务客户规模")
    private String serviceCustomerScale;
    /** 渠道负责人 精确 */
    @ApiModelProperty("渠道负责人")
    private Long channelUserId;
    /** 合作区域 udc[crm:customer_region] 精确 */
    @ApiModelProperty("合作区域 udc[crm:customer_region]")
    private String collaborateRegion;
    /** 对接人类型 udc[CRM:BUSINESS_PARTNER:CONTACT_TYPE] 精确 */
    @ApiModelProperty("对接人类型 udc[CRM:BUSINESS_PARTNER:CONTACT_TYPE]")
    private String contactPeopleType;
    /** 我司负责人bu 精确 */
    @ApiModelProperty("我司负责人bu")
    private Long buManageUserId;
    /** 我司负责人电话 精确 */
    @ApiModelProperty("我司负责人电话")
    private String buManagePhone;
    /** 我司负责人邮箱 精确 */
    @ApiModelProperty("我司负责人邮箱")
    private String buManageEmail;
    /** 合作伙伴标签 */
    @ApiModelProperty("合作伙伴标签")
    private String collaborateTag;
    /** 合作伙伴关键词 精确 */
    @ApiModelProperty("合作伙伴关键词")
    private String collaborateKeyword;
    /** 公司介绍附件 精确 */
    @ApiModelProperty("公司介绍附件")
    private String fileCodes3;


    //流程字段
    /** 流程实例ID */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /** 审批时间 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /** 排序号 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    @ApiModelProperty("流程提交标志")
    private Boolean submit;
}
