package com.elitesland.tw.tw5.api.prd.partner.identity.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 业务伙伴-合作伙伴
 *
 * @author wangly
 * @date 2023-05-16
 */
@Getter
@Setter
public class BusinessCollaboratePartnerInfoQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 业务伙伴id 精确 */
    @ApiModelProperty("业务伙伴id")
    private Long partnerId;
    /** 合作状态 udc[BUSINESS:CUSTOMER:STATUS] 精确 */
    @ApiModelProperty("合作状态 udc[BUSINESS:CUSTOMER:STATUS]")
    private String collaborateStatus;
    /** 合作等级 udc[crm:customer_grade] 精确 */
    @ApiModelProperty("合作等级 udc[crm:customer_grade]")
    private String collaborateGradle;
    /** 合作产品 精确 */
    @ApiModelProperty("合作产品")
    private String collaborateProduct;
    /** 合作开始时间 精确 */
    @ApiModelProperty("合作开始时间")
    private LocalDate startTime;
    /** 合作结束时间 精确 */
    @ApiModelProperty("合作结束时间")
    private LocalDate endTime;
    /** 合作期间说明 精确 */
    @ApiModelProperty("合作期间说明")
    private String collaborateDescription;
    /** 产品介绍附件 精确 */
    @ApiModelProperty("产品介绍附件")
    private String fileCodes1;
    /** 合作协议附件 精确 */
    @ApiModelProperty("合作协议附件")
    private String fileCodes2;
    /** 扩展字段1 精确 */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /** 扩展字段2 精确 */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /** 扩展字段3 精确 */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /** 扩展字段4 精确 */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /** 扩展字段5 精确 */
    @ApiModelProperty("扩展字段5")
    private String ext5;
    /** 合作形式 精确 */
    @ApiModelProperty("合作形式")
    private String collaborateForm;
    /** 合作类别 udc[CRM:BUSINESS_PARTNER:COLLABORATE_TYPE] 精确 */
    @ApiModelProperty("合作类别 udc[CRM:BUSINESS_PARTNER:COLLABORATE_TYPE]")
    private String collaborateType;
    /** 伙伴服务行业 精确 */
    @ApiModelProperty("伙伴服务行业")
    private String collaborateServiceIndustry;
    /** 服务典型客户 精确 */
    @ApiModelProperty("服务典型客户")
    private String collaborateCustomer;
    /** 服务客户规模 精确 */
    @ApiModelProperty("服务客户规模")
    private String serviceCustomerScale;
    /** 渠道负责人 精确 */
    @ApiModelProperty("渠道负责人")
    private Long channelUserId;
    /** 合作区域 udc[crm:customer_region] 精确 */
    @ApiModelProperty("合作区域 udc[crm:customer_region]")
    private String collaborateRegion;
    /** 对接人类型 udc[CRM:BUSINESS_PARTNER:CONTACT_TYPE] 精确 */
    @ApiModelProperty("对接人类型 udc[CRM:BUSINESS_PARTNER:CONTACT_TYPE]")
    private String contactPeopleType;
    /** 我司负责人bu 精确 */
    @ApiModelProperty("我司负责人bu")
    private Long buManageUserId;
    /** 我司负责人电话 精确 */
    @ApiModelProperty("我司负责人电话")
    private String buManagePhone;
    /** 我司负责人邮箱 精确 */
    @ApiModelProperty("我司负责人邮箱")
    private String buManageEmail;
    /** 合作伙伴关键词 精确 */
    @ApiModelProperty("合作伙伴关键词")
    private String collaborateKeyword;

    /** 合作伙伴标签 */
    @ApiModelProperty("合作伙伴标签")
    private String collaborateTag;
    /** 公司介绍附件 精确 */
    @ApiModelProperty("公司介绍附件")
    private String fileCodes3;
}
