package com.elitesland.tw.tw5.api.prd.partner.identity.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * 业务伙伴-供应商信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Getter
@Setter
public class BusinessSupplierInfoQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 业务伙伴id business_partner.id 精确
     */
    @ApiModelProperty("业务伙伴id")
    private Long partnerId;
    /**
     * 供应商编号
     */
    @ApiModelProperty("供应商编号")
    private String supplierNo;

    /**
     * 供应商状态 udc[CRM:BUSINESS_PARTNER:STATUS] 精确
     */
    @ApiModelProperty("供应商状态 udc[CRM:BUSINESS_PARTNER:STATUS]")
    private String supplierStatus;
    /**
     * 供应商级别 udc[crm:customer_grade] 精确
     */
    @ApiModelProperty("供应商级别 udc[crm:customer_grade]")
    private String supplierGradle;
    /**
     * 供应商产品 精确
     */
    @ApiModelProperty("供应商产品")
    private String supplierProduct;
    /**
     * 供货开始时间 精确
     */
    @ApiModelProperty("供货开始时间")
    private LocalDate startTime;
    /**
     * 供货结束时间 精确
     */
    @ApiModelProperty("供货结束时间")
    private LocalDate endTime;
    /**
     * 结算周期 精确
     */
    @ApiModelProperty("结算周期")
    private String settlementPeriod;
    /**
     * 供货期间说明 精确
     */
    @ApiModelProperty("供货期间说明")
    private String supplyDescription;
    /**
     * 扩展字段1 精确
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /**
     * 扩展字段2 精确
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3 精确
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字段4 精确
     */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /**
     * 扩展字段5 精确
     */
    @ApiModelProperty("扩展字段5")
    private String ext5;
    /**
     * 是否同步过JDE
     */
    @ApiModelProperty("是否同步过JDE")
    private Boolean syncJdeFlag;



    /**
     * 业务伙伴id business_partner.id 精确
     */
    @ApiModelProperty("业务伙伴ids")
    private List<Long> partnerIds;
}
