package com.elitesland.tw.tw5.api.prd.partner.identity.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerSimpleVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessCutomerManagePayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BusinessPartnerListSimpleQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BusinessPartnerQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessCutomerManageVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCustomerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessCustomerInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerSimpleVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyCustomerVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import org.springframework.scheduling.annotation.Async;

import java.util.List;

/**
 * 业务伙伴-客户信息
 *
 * @author wangly
 * @date 2023-05-16
 */
public interface BusinessCustomerInfoService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessCustomerInfoVO}>
     */
    PagingVO<BusinessCustomerInfoVO> queryPaging(BusinessCustomerInfoQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessCustomerInfoVO}>
     */
    List<BusinessCustomerInfoVO> queryListDynamic(BusinessCustomerInfoQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessCustomerInfoVO}
     */
    BusinessCustomerInfoVO queryByKey(Long key);

    /**
     * 通过业务伙伴主键查询
     *
     * @param partnerId 业务伙伴主键
     * @return {@link BusinessCustomerInfoVO}
     */
    BusinessCustomerInfoVO queryByPartnerId(Long partnerId);
    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessCustomerInfoVO}
     */
    BusinessCustomerInfoVO insert(BusinessCustomerInfoPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessCustomerInfoVO}
     */
    BusinessCustomerInfoVO update(BusinessCustomerInfoPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);
    /**
     * 查询所有客户
     *
     */
    List<BusinessCustomerSimpleVO> listSimple(String identity,String customerStatus);

    /**
     * 查询所有客户-分页
     *
     */
    PagingVO<BusinessCustomerSimpleVO> listSimplePaging(BusinessPartnerListSimpleQuery query);


    /**
     *客户详情简要查询
     *
     */
    CrmCustomerSimpleVO listSimpleByPartnerId(Long partnerId);

    /**
     *分级策略-客户查询
     *
     */
    List<BusinessStrategyCustomerVO> queryCustomerList(BusinessPartnerQuery query);

    /**
     *将所有的客户的客户级别 分数 strategyId indexInfo字段置空
     *
     */
    void updateCustomerGrade();
    //更新客户的客户级别
    void changeCustomerGrade(Long partnerId,String customerGrade);

    /**
     * 客户管理分页查询
     *
     */
    PagingVO<BusinessCutomerManageVO> queryCustomerManage(BusinessCustomerInfoQuery query);

    /**
     * 客户管理列表查询
     *
     */
    List<BusinessCutomerManageVO> queryCustomerManageList(BusinessCustomerInfoQuery query);

    /**
     * 客户管理-通过业务伙伴id查询
     *
     */
    BusinessCutomerManageVO queryCustomerManageByPartnerId(Long id);
    /**
     * 客户管理-更新客户管理的团队成员
     *
     */
    void updateCustomerManageTeamMember(BusinessCutomerManagePayload businessCutomerManagePayload);

    /**
     * 客户管理-客户激活
     *
     */
    void  activeCustomer(Long partnerId,String partnerName,Long bookId);

    /**
     * 客户管理-客户激活带工作流
     *
     */
    void  activeCustomerWithWorkFlow(Long partnerId,String partnerName,Long bookId);

    /**
     * 客户管理-客户暂挂
     *
     */
    void  pendingCustomer(Long partnerId,String partnerName);

    /**
     * 客户管理-客户更新同步4.0
     *
     */
//    void businessCustomerSyncTw4(String param);


    /**
     * 更新客户表的修改时间 方便数据同步4.0
     */
    void updateBusinessParnerCustomerModifyTime(Long partnerId);

    Boolean activeCustomerCheck(Long bookId);
}
