package com.elitesland.tw.tw5.api.prd.partner.identity.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessSupplierInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessSupplierInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessSupplierInfoVO;

import java.util.List;

/**
 * 业务伙伴-供应商信息
 *
 * @author wangly
 * @date 2023-05-16
 */
public interface BusinessSupplierInfoService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessSupplierInfoVO}>
     */
    PagingVO<BusinessSupplierInfoVO> queryPaging(BusinessSupplierInfoQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessSupplierInfoVO}>
     */
    List<BusinessSupplierInfoVO> queryListDynamic(BusinessSupplierInfoQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessSupplierInfoVO}
     */
    BusinessSupplierInfoVO queryByKey(Long key);
    /**
     * 通过业务伙伴主键查询
     *
     * @param partnerId 业务伙伴主键
     * @return {@link BusinessSupplierInfoVO}
     */
    BusinessSupplierInfoVO queryByPartnerId(Long partnerId);
    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessSupplierInfoVO}
     */
    BusinessSupplierInfoVO insert(BusinessSupplierInfoPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessSupplierInfoVO}
     */
    BusinessSupplierInfoVO update(BusinessSupplierInfoPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 业务伙伴-供应商信息-供应商激活
     *
     */
    void  updateSupplierStatus(Long partnerId,String partnerName,String supplierStatus);

    /**
     * 校验供应商激活
     * @param bookId
     * @return
     */
    Boolean activeSupplierCheck(Long bookId);


    /**
     * 校验供应商激活（带变更流程）
     * @param bookId
     * @return
     */
    Boolean activeSupplierCheckWithChange(Long bookId);

    /**
     * 根据供应商bookid查询供应商信息
     * @param supplierBookId
     * @return
     */
    BusinessSupplierInfoVO quertByBookId(Long supplierBookId);
}
