package com.elitesland.tw.tw5.api.prd.partner.strategy.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 分级策略模型指标
 *
 * @author wangly
 * @date 2023-06-19
 */
@Getter
@Setter
public class BusinessModelIndexPayload extends TwCommonPayload  implements Serializable {
    /** 模型id business_strategy_model.id */
    @ApiModelProperty("模型id business_strategy_model.id")
    private Long modelId;
    /** 指标名称 */
    @ApiModelProperty("指标名称")
    private String modelIndexName;
    /** 数据库字段 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE_FIELD] */
    @ApiModelProperty("数据库字段 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE_FIELD]")
    private String sourceField;
    /** 权重 */
    @ApiModelProperty("权重")
    private BigDecimal weight;
    /** 排序号 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 拓展字段1 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /** 拓展字段4 */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /** 拓展字段5 */
    @ApiModelProperty("拓展字段5")
    private String ext5;

    /** 模型指标配置集合 */
    @ApiModelProperty("模型指标配置集合")
    private List<BusinessModelIndexSettingPayload> businessModelIndexSettingPayloadList;
}
