package com.elitesland.tw.tw5.api.prd.partner.strategy.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 分级策略范围配置
 *
 * @author wangly
 * @date 2023-06-16
 */
@Getter
@Setter
public class BusinessStrategyRangeSettingPayload extends TwCommonPayload  implements Serializable {
    /** 分级策略id business_strategy.id */
    @ApiModelProperty("分级策略id business_strategy.id")
    private Long strategyId;
    /** 策略范围目标值 udc[CRM:BUSINESS_STRATEGY:RANGE:TARGET] */
    @ApiModelProperty("策略范围目标值 udc[CRM:BUSINESS_STRATEGY:RANGE:TARGET]")
    private String examTarget;
    /** 筛选字段key */
    @ApiModelProperty("筛选字段key")
    private String fieldKey;
    /** 筛选字段名称 */
    @ApiModelProperty("筛选字段名称")
    private String fieldName;
    /** 搜索类型 */
    @ApiModelProperty("搜索类型")
    private String searchType;
    /** 搜索范围 */
    @ApiModelProperty("搜索范围")
    private String searchScope;
    /** 搜索条件,多个条件以英文逗号隔开 */
    @ApiModelProperty("搜索条件,多个条件以英文逗号隔开")
    private String searchCondition;
    /** 设置项KEY */
    @ApiModelProperty("设置项KEY")
    private String settingKey;
    /** 设置项名称 */
    @ApiModelProperty("设置项名称")
    private String settingName;
    /** 设置项值 */
    @ApiModelProperty("设置项值")
    private String settingValue;
    /** 排序号 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 拓展字段1 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /** 拓展字段4 */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /** 拓展字段5 */
    @ApiModelProperty("拓展字段5")
    private String ext5;
}
