package com.elitesland.tw.tw5.api.prd.partner.strategy.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessModelIndexPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessModelIndexQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessModelIndexVO;

import java.util.List;

/**
 * 分级策略模型指标
 *
 * @author wangly
 * @date 2023-06-19
 */
public interface BusinessModelIndexService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessModelIndexVO}>
     */
    PagingVO<BusinessModelIndexVO> queryPaging(BusinessModelIndexQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessModelIndexVO}>
     */
    List<BusinessModelIndexVO> queryListDynamic(BusinessModelIndexQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessModelIndexVO}
     */
    BusinessModelIndexVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessModelIndexVO}
     */
    BusinessModelIndexVO insert(BusinessModelIndexPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessModelIndexVO}
     */
    BusinessModelIndexVO update(BusinessModelIndexPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessModelIndexPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 通过主表id删除明细数据
     *
     * @param modelId business_strategy_model.id 模型id
     *
     */
    void deleteSoftByModelId(Long modelId);
}
