package com.elitesland.tw.tw5.api.prd.partner.strategy.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyIndexRecordPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyIndexRecordQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyIndexRecordVO;

import java.util.List;

/**
 * 分级策略-分级记录
 *
 * @author wangly
 * @date 2023-06-28
 */
public interface BusinessStrategyIndexRecordService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessStrategyIndexRecordVO}>
     */
    PagingVO<BusinessStrategyIndexRecordVO> queryPaging(BusinessStrategyIndexRecordQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessStrategyIndexRecordVO}>
     */
    List<BusinessStrategyIndexRecordVO> queryListDynamic(BusinessStrategyIndexRecordQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessStrategyIndexRecordVO}
     */
    BusinessStrategyIndexRecordVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessStrategyIndexRecordVO}
     */
    BusinessStrategyIndexRecordVO insert(BusinessStrategyIndexRecordPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessStrategyIndexRecordVO}
     */
    BusinessStrategyIndexRecordVO update(BusinessStrategyIndexRecordPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessStrategyIndexRecordPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 通过customerId 查询上次执行的分级记录
     *
     * @param customerId 客户id
     * @return {@link List}<{@link BusinessStrategyIndexRecordVO}>
     */
    List<BusinessStrategyIndexRecordVO> queryListByCustomerId(Long customerId);

}
