package com.elitesland.tw.tw5.api.prd.partner.strategy.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;


/**
  * 分级策略模型指标配置
  *
  * @author wangly
  * @date 2023-06-19
  */
@Getter
@Setter
public class BusinessModelIndexSettingVO extends BaseViewModel implements Serializable {
    /** 模型id business_strategy_model.id */
    @ApiModelProperty("模型id business_strategy_model.id")
    private Long modelId;
    /** 指标id business_strategy_model_index.id */
    @ApiModelProperty("指标id business_strategy_model_index.id")
    private Long indexId;
    /** 指标名称 */
    @ApiModelProperty("指标名称")
    private String indexName;
    /** 数据源字段 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE_FIELD] */
    @ApiModelProperty("数据源字段 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE_FIELD]")
    private String sourceFiled;
    /** 数据源字段 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE_FIELD] */
    @ApiModelProperty("数据源字段 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE_FIELD]")
    private String sourceFiledDesc;
    /** 数据源字段选项 (系统下拉选择项) */
    @ApiModelProperty("指标明细-选项")
    private String sourceFiledOption;
    /** 数据源字段选项 (系统下拉选择项) */
    @ApiModelProperty("指标明细-选项描述")
    private String sourceFiledOptionDesc;
    /** 选项分数 */
    @ApiModelProperty("指标明细-对应分值")
    private BigDecimal optionScore;
    /** 拓展字段1 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /** 拓展字段4 */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /** 拓展字段5 */
    @ApiModelProperty("拓展字段5")
    private String ext5;
}
