package com.elitesland.tw.tw5.api.prd.partner.strategy.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


/**
  * 分级策略模型指标
  *
  * @author wangly
  * @date 2023-06-19
  */
@Getter
@Setter
public class BusinessModelIndexVO extends BaseViewModel implements Serializable {
    /** 模型id business_strategy_model.id */
    @ApiModelProperty("模型id business_strategy_model.id")
    private Long modelId;
    /** 指标名称 */
    @ApiModelProperty("指标名称")
    private String modelIndexName;
    /** 数据库字段 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE_FIELD] */
    @ApiModelProperty("数据库字段 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE_FIELD]")
    private String sourceField;

    /** 数据库字段 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE_FIELD] */
    @ApiModelProperty("数据库字段 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE_FIELD]")
    @UdcName(udcName = "CRM:BUSINESS_STRATEGY_MODEL:SOURCE_FIELD",codePropName = "sourceField")
    private String sourceFieldDesc;
    /** 权重 */
    @ApiModelProperty("权重")
    private BigDecimal weight;

    /** 拓展字段1 */
    @ApiModelProperty("拓展字段1")
    private String ext1;

    /** 模型指标配置集合 */
    @ApiModelProperty("模型指标配置集合")
    private List<BusinessModelIndexSettingVO> businessModelIndexSettingVOList;
}
