package com.elitesland.tw.tw5.api.prd.partner.strategy.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;


/**
  * 分级策略等级配置
  *
  * @author wangly
  * @date 2023-06-16
  */
@Getter
@Setter
public class BusinessStrategyGradeSettingVO extends BaseViewModel implements Serializable {
    /** 策略id business_strategy.id */
    @ApiModelProperty("策略id business_strategy.id")
    private Long strategyId;

    /** 等级类别 udc[crm:customer_grade] */
    @ApiModelProperty("等级名称 udc[crm:customer_grade]")
    private String gradleType;

    /** 等级类别 udc[crm:customer_grade] */
    @ApiModelProperty("等级名称描述 udc[crm:customer_grade]")
    @UdcName(udcName = "crm:customer_grade",codePropName = "gradleType")
    private String gradleTypeDesc;

    /** 分数开始 */
    @ApiModelProperty("分数开始")
    private BigDecimal scoreStart;

    /** 分数结束 */
    @ApiModelProperty("分数结束")
    private BigDecimal scoreEnd;

    /** 排序号 */
    @ApiModelProperty("排序号")
    private Integer sortNo;

    /** 拓展字段1 */
    @ApiModelProperty("拓展字段1")
    private String ext1;

    /** 拓展字段2 */
    @ApiModelProperty("拓展字段2")
    private String ext2;

    /** 拓展字段3 */
    @ApiModelProperty("拓展字段3")
    private String ext3;

    /** 拓展字段4 */
    @ApiModelProperty("拓展字段4")
    private String ext4;

    /** 拓展字段5 */
    @ApiModelProperty("拓展字段5")
    private String ext5;
}
