package com.elitesland.tw.tw5.api.prd.partner.strategy.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


/**
  * 分级策略模型配置
  *
  * @author wangly
  * @date 2023-06-19
  */
@Getter
@Setter
public class BusinessStrategyModelVO extends BaseViewModel implements Serializable {
    /** 模型编号 */
    @ApiModelProperty("模型编号")
    private String modelNo;

    /** 模型名称 */
    @ApiModelProperty("模型名称")
    private String modelName;

    /** 模型类型 udc[CRM:BUSINESS_STRATEGY_MODEL:TYPE] */
    @ApiModelProperty("模型类型 udc[CRM:BUSINESS_STRATEGY_MODEL:TYPE]")
    private String modelType;

    /** 模型类型 udc[CRM:BUSINESS_STRATEGY_MODEL:TYPE] */
    @ApiModelProperty("模型类型描述 udc[CRM:BUSINESS_STRATEGY_MODEL:TYPE]")
    @UdcName(udcName = "CRM:BUSINESS_STRATEGY_MODEL:TYPE",codePropName = "modelType")
    private String modelTypeDesc;

    /** 是否标准模版 udc[CRM:BUSINESS_STRATEGY_MODEL:FLAG] */
    @ApiModelProperty("是否标准模版 udc[CRM:BUSINESS_STRATEGY_MODEL:FLAG]")
    private Boolean standaryFlag;

    /** 标准模版是否更改 */
    @ApiModelProperty("标准模版是否更改")
    private Boolean standaryModifyFlag;

    /** 是否标准模版 udc[CRM:BUSINESS_STRATEGY_MODEL:FLAG] */
    @ApiModelProperty("是否标准模版描述 udc[CRM:BUSINESS_STRATEGY_MODEL:FLAG]")
    @UdcName(udcName = "CRM:BUSINESS_STRATEGY_MODEL:FLAG",codePropName = "standaryFlag")
    private String standaryFlagDesc;

    /** 数据来源 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE] */
    @ApiModelProperty("数据来源 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE]")
    private String source;

    /** 数据来源 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE] */
    @ApiModelProperty("数据来源描述 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE]")
    @UdcName(udcName = "CRM:BUSINESS_STRATEGY_MODEL:SOURCE",codePropName = "source")
    private String sourceDesc;

    /** 时间范围 udc[CRM:BUSINESS_STRATEGY_MODEL:DATE] */
    @ApiModelProperty("时间范围 udc[CRM:BUSINESS_STRATEGY_MODEL:DATE]")
    private String dateRange;

    /** 时间范围 udc[CRM:BUSINESS_STRATEGY_MODEL:DATE] */
    @ApiModelProperty("时间范围 udc[CRM:BUSINESS_STRATEGY_MODEL:DATE]")
    @UdcName(udcName = "CRM:BUSINESS_STRATEGY_MODEL:DATE",codePropName = "dateRange")
    private String dateRangeDescc;

    /** 拓展字段1 */
    @ApiModelProperty("拓展字段1")
    private String ext1;

    /** 模型指标集合 */
    @ApiModelProperty("模型指标集合")
    private List<BusinessModelIndexVO> businessModelIndexVOList;

    /** R权重 */
    @ApiModelProperty("R权重")
    private BigDecimal RWeight;

    /** F权重 */
    @ApiModelProperty("F权重")
    private BigDecimal FWeight;

    /** M权重 */
    @ApiModelProperty("M权重")
    private BigDecimal MWeight;
}
