package com.elitesland.tw.tw5.api.prd.partner.team.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 业务伙伴-团队成员
 *
 * @author wangly
 * @date 2023-05-16
 */
@Getter
@Setter
public class BusinessTeamMemberQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 业务伙伴id business_partner.id 精确 */
    @ApiModelProperty("业务id")
    private Long objectId;

    /** 业务伙伴id business_partner.id 精确 */
    @ApiModelProperty("业务id集合")
    private List<Long> objectIdList;

    /** 业务类型 */
    @ApiModelProperty("业务类型 udc[CRM:BUSINESS_PARTNER:TEAM_TYPE:PARTNER]")
    private String type;

    /**  用户id 精确 */
    @ApiModelProperty(" 用户id")
    private Long userId;
    /** 成员名称 精确 */
    @ApiModelProperty("成员名称")
    private String memberName;
    /** 成员角色 精确 */
    @ApiModelProperty("成员角色")
    private String memberRole;
    /** 成员角色名称 精确 */
    @ApiModelProperty("成员角色名称")
    private String memberRoleName;
    /** 是否为创建者 精确 */
    @ApiModelProperty("是否为创建者")
    private Boolean isCreator;
    /** 组织id 精确 */
    @ApiModelProperty("组织id")
    private Long orgId;
    /** 维度id 精确 */
    @ApiModelProperty("维度id")
    private Long dimensionId;
    /** 组织改变前ID 精确 */
    @ApiModelProperty("组织改变前ID")
    private Long changeId;
    /** 组织名称 精确 */
    @ApiModelProperty("组织名称")
    private String orgName;
    /** 组织编号 精确 */
    @ApiModelProperty("组织编号")
    private String orgCode;
    /** 组织状态 精确 */
    @ApiModelProperty("组织状态")
    private String orgStatus;
    /** 排序号 精确 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 扩展字段1 精确 */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /** 扩展字段2 精确 */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /** 扩展字段3 精确 */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /** 扩展字段4 精确 */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /** 扩展字段5 精确 */
    @ApiModelProperty("扩展字段5")
    private String ext5;
}
