package com.elitesland.tw.tw5.api.prd.pay.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * 支付管理-支付履历
 *
 * @author wangly
 * @date 2023-12-12
 */
@Getter
@Setter
public class TDocHistVO extends BaseViewModel implements Serializable {
    /**
     * 履历类型
     */
    @ApiModelProperty("履历类型")
    private String histType;
    /**
     * 履历详细
     */
    @ApiModelProperty("履历详细")
    private String histDtl;
    /**
     * 履历日期时间
     */
    @ApiModelProperty("履历日期时间")
    private LocalDateTime histTime;
    /**
     * 单据id
     */
    @ApiModelProperty("单据id")
    private Long docId;
    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private String docNo;
    /**
     * 单据类型
     */
    @ApiModelProperty("单据类型")
    private String docType;
    /**
     * 用户id
     */
    @ApiModelProperty("用户id")
    private Long ownerId;

    /**
     * 用户id
     */
    @ApiModelProperty("用户id")
    @UdcName(udcName = "USER",codePropName = "ownerId")
    private String ownerName;
}
