package com.elitesland.tw.tw5.api.prd.personplan.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanDtlPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanDtlQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanDtlVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjuster;
import java.util.List;
import java.util.Map;


/**
 * @author : WWW
 * @date : 2024-2-21
 * @desc : 人员规划明细Service
 */
public interface PersonPlanDtlService {

    /**
     * 新增人员规划明细数据
     *
     * @param personPlanDtlPayload
     * @return
     */
    PersonPlanDtlVO save(PersonPlanDtlPayload personPlanDtlPayload);


    List<PersonPlanDtlVO> saveAll(List<PersonPlanDtlPayload> personPlanDtlPayloadList, Long planId);

    /**
     * 根据id批量删除不在list中的人员规划明细
     *
     * @param idNotInList
     * @return
     */
    void delByNotInIdList(List<Long> idNotInList);

    /**
     * 根据主键更新
     *
     * @param personPlanDtlPayload
     * @return
     */
    PersonPlanDtlVO updateAll(PersonPlanDtlPayload personPlanDtlPayload);

    /**
     * 根据主键获取详情
     *
     * @param id
     * @return
     */
    PersonPlanDtlVO get(Long id);

    /**
     * 分页查询列表
     *
     * @param personPlanDtlQuery
     * @return
     */
    PagingVO<PersonPlanDtlVO> page(PersonPlanDtlQuery personPlanDtlQuery);

    /**
     * 根据主键批量删除
     *
     * @param ids
     * @return
     */
    Long del(List<Long> ids);

    /**
     * 获取列表查询
     *
     * @param personPlanDtlQuery
     * @return
     */
    List<PersonPlanDtlVO> getList(PersonPlanDtlQuery personPlanDtlQuery);

    /**
     * 根据条件修改
     *
     * @param personPlanDtlPayload
     * @return
     */
    Long update(PersonPlanDtlPayload personPlanDtlPayload);

    /**
     * 通过人员规划id删除明细
     *
     * @param planIds
     * @return
     */
    void deleteByPlanIds(List<Long> planIds);

    /**
     * 通过人员规划id导出模板
     *
     * @param planId
     * @return
     */
    void tmpDownload(HttpServletResponse response, Long planId);

    /**
     * 批量立项导入excel
     *
     * @param file 请求响应
     */
    String batchImport(MultipartFile file, Long planId);

    /**
     * 获取日期范围
     *
     * @param startDate
     * @param endDate
     * @param adjuster
     * @return
     */
    List<Map<String, String>> dataRange(LocalDate startDate, LocalDate endDate, TemporalAdjuster adjuster);

    void insertPlanTmp();
}

