package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 项目模板活动
 *
 * @author xxb
 * @date 2023-08-03
 */
@Getter
@Setter
public class PmsProjectTemplateActPayload extends TwCommonPayload  implements Serializable {
    /** 模板Id */
    @ApiModelProperty("模板Id")
    private Long templateId;
    /** 活动编号 */
    @ApiModelProperty("活动编号")
    private String actCode;
    /** 活动名称 */
    @ApiModelProperty("活动名称")
    private String actName;
    /** 规划天数 */
    @ApiModelProperty("规划天数")
    private BigDecimal plannedDays;
    /** 规划当量 */
    @ApiModelProperty("规划当量")
    private BigDecimal planningEquivalent;
    /** 里程碑标记 1是 0不是 */
    @ApiModelProperty("里程碑标记 1是 0不是")
    private Integer milestoneFlag = 0 ;
    /** 阶段标记 1是 0不是 */
    @ApiModelProperty("阶段标记 1是 0不是")
    private Integer actStageFlag = 0;

    @ApiModelProperty("序号")
    private Integer sortNo;

}
