package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * 派发
 *
 * @author xxb
 * @date 2023-08-07
 */
@Getter
@Setter
public class PmsDistributeQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 派发类型 精确
     */
    @ApiModelProperty("派发类型")
    private String reasonType;
    /**
     * 派发事由ID 精确
     */
    @ApiModelProperty("派发事由ID")
    private Long reasonId;
    @ApiModelProperty("派发事由")
    private String reasonName;
    /**
     * 派发编号 精确
     */
    @ApiModelProperty("派发编号")
    private String distNo;
    /**
     * 指派资源ID 精确
     */
    @ApiModelProperty("指派资源ID")
    private Long disterResId;
    /**
     * 接收资源ID 精确
     */
    @ApiModelProperty("接收资源ID")
    private Long receiverResId;
    /**
     * 派发状态 精确
     */
    @ApiModelProperty("派发状态")
    private String distStatus;
    /**
     * 审批状态 精确
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 派发方式 精确
     */
    @ApiModelProperty("派发方式")
    private String distMethod;
    /**
     * 派发说明 精确
     */
    @ApiModelProperty("派发说明")
    private String distDesc;
    /**
     * 复合能力 精确
     */
    @ApiModelProperty("复合能力")
    private Long capasetLevelId;
    /**
     * 预计开始日期 精确
     */
    @ApiModelProperty("预计开始日期")
    private LocalDate planStartDate;
    /**
     * 预计结束日期 精确
     */
    @ApiModelProperty("预计结束日期")
    private LocalDate planEndDate;


    @ApiModelProperty("工作地国家")
    private String workCountry;

    @ApiModelProperty("工作地省")
    private String workProvince;

    @ApiModelProperty("现场远程")
    private String workStyle;

    @ApiModelProperty("时间要求")
    private String timeRequirement;

    @ApiModelProperty("兼职|全职")
    private String workMethod;

    @ApiModelProperty("工作地")
    private String workPlace;


    @ApiModelProperty("接收人是自己")
    private Boolean myDistFlag = false;

    /**
     * 派发状态类型0：不等于，1：等于
     */
    @ApiModelProperty("派发状态类型0：不等于，1：等于")
    private String distStatusType;

    /**
     * 派发表 关联 响应表
     */
    private Boolean distInnerJoinRespondFlag = false;

    /**
     * 响应表 关联 派发表
     */
    private Boolean respondInnerJoinDistFlag = false;


    /**
     * 响应资源ID
     */
    private Long respondentResId;

    /**
     * 响应状态 精确
     */
    private String respStatus;

    /**
     * 是否邀请 精确
     */
    private Integer inviteFlag;

    /**
     * 登录人未响应过的派发数据
     */
    private List<Long> notInIds;

    /**
     * 广播表 关联 派发表
     */
    private Boolean broadcastJoinDistFlag = false;


    @ApiModelProperty("派发开始日期")
    private LocalDate startDate;

    @ApiModelProperty("派发结束日期")
    private LocalDate endDate;

    /**
     * 需要权限
     */
    private Boolean permissionFlag = true;
}
