package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * 项目会议纪要
 *
 * @author zoey
 * @date 2024-05-28
 */
@Getter
@Setter
public class PmsProjectSummaryQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 纪要编号 精确
     */
    @ApiModelProperty("纪要编号")
    private String summaryNo;
    /**
     * 纪要名称 模糊
     */
    @ApiModelProperty("纪要名称")
    private String summaryName;
    /**
     * 项目id 精确
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 消息内容 精确
     */
    @ApiModelProperty("消息内容")
    private String summaryContent;
    /**
     * 状态（0：已保存；1：已发布） 精确
     */
    @ApiModelProperty("状态（0：已保存；1：已发布）")
    private Integer summaryStatus;

    /**
     * 项目名称或编号
     */
    @ApiModelProperty("项目名称或编号")
    private String projSearch;

    /**
     * 项目经理资源id
     */
    @ApiModelProperty("项目经理资源id")
    private Long pmResId;


    /**
     * 交付BU_ID
     */
    @ApiModelProperty("交付BU_ID")
    private Long deliBuId;


    /**
     * 交付负责人
     */
    @ApiModelProperty("交付负责人")
    private Long deliUserId;

    /**
     * 记录日期
     */
    @ApiModelProperty("记录日期")
    private List<LocalDate> summaryDate;


    /**
     * 工作类型
     */
    @ApiModelProperty("工作类型")
    private String workType;


}
