package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 资源计划人天明细
 *
 * @author xxb
 * @date 2023-08-11
 */
@Getter
@Setter
public class PmsResourcePlanDaysQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 关联资源计划ID 精确
     */
    @ApiModelProperty("关联资源计划ID")
    private Long planId;
    /**
     * 规划角色明细ID 精确
     */
    @ApiModelProperty("规划角色明细ID")
    private Long roleDetailId;
    /**
     * 年周 精确
     */
    @ApiModelProperty("年周")
    private String yearWeek;
    /**
     * 规划工作天数 精确
     */
    @ApiModelProperty("规划工作天数")
    private BigDecimal days;

    /**
     * 超过规划工作天数 精确
     */
    @ApiModelProperty("工作")
    private BigDecimal largeDays;

    private List<Long> roleDetailIds;

    @ApiModelProperty("id不为空")
    private Boolean notNullPlanIdFlag;
}
