package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
    import java.time.LocalDate;
import java.util.List;

/**
 * 资源规划
 *
 * @author xxb
 * @date 2023-08-11
 */
@Getter
@Setter
public class PmsResourcePlanQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 计划类型 精确 */
    @ApiModelProperty("计划类型 、商机；2、项目")
    private String planType;
    /** 关联对象ID 精确 */
    @ApiModelProperty("关联对象ID")
    private Long objId;
    /** 关联对象 精确 */
    @ApiModelProperty("关联对象")
    private String objName;
    /** 开始日期 精确 */
    @ApiModelProperty("开始日期")
    private LocalDate startDate;
    /** 结束日期 精确 */
    @ApiModelProperty("结束日期")
    private LocalDate endDate;
    /** 持续时长 精确 */
    @ApiModelProperty("持续时长")
    private Integer duration;
    /** 资源规划状态 0正常 精确 */
    @ApiModelProperty("资源规划状态 0正常")
    private String planningStatus;
    @ApiModelProperty("资源规划周期: WEEK周 MONTH月")
    private String resourcePlanningCycle;

    /** 隐藏标志 */
    @ApiModelProperty("隐藏标志")
    private Integer hiddenFlag;

    private List<Long> objIds;

    /** 以下是预留字段 */

//    /** 商机销售阶段  --- 给商机类型资源规划用的 精确 */
//    @ApiModelProperty("商机销售阶段  --- 给商机类型资源规划用的")
//    private String salePhase;
//    /** 成单概率交付角度 --- 给商机类型资源规划用的 精确 */
//    @ApiModelProperty("成单概率交付角度 --- 给商机类型资源规划用的")
//    private String probability;
//    /** 版本号  精确 */
//    @ApiModelProperty("版本号 ")
//    private String versionNo;
//    /** 变更原因 精确 */
//    @ApiModelProperty("变更原因")
//    private String changeReason;
//    /** 交付负责人 精确 */
//    @ApiModelProperty("交付负责人")
//    private Long deliResId;
//    /** BUID 精确 */
//    @ApiModelProperty("BUID")
//    private Long buId;
}
