package com.elitesland.tw.tw5.api.prd.pms.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistributePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsDistributeQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistributeVO;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;

import java.util.List;

/**
 * 派发
 *
 * @author xxb
 * @date 2023-08-07
 */
public interface PmsDistributeService {


    /**
     * 新增或修改
     *
     * @param payload 单据数据
     */
    PmsDistributeVO insertOrUpdate(PmsDistributePayload payload);

    /**
     * 分页列表--- 我的派发、派发列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsDistributeVO}>
     */
    PagingVO<PmsDistributeVO> queryPaging(PmsDistributeQuery query);

    /**
     * 我收到的响应
     * 作为派发资源，广播出去派发对象后，可能会收到各方的响应（感兴趣或不感兴趣操作），响应数据会在此列表展示。
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsDistributeVO}>
     */
    PagingVO<PmsDistributeVO> iReceivedRespond(PmsDistributeQuery query);

    /**
     * 我收到的邀请
     * 如果 登录人=被邀请人 且 还未响应（感兴趣or不感兴趣）过，可以看到的派发数据。
     *
     * @param query
     * @return
     */
    PagingVO<PmsDistributeVO> iReceivedInvitation(PmsDistributeQuery query);


    /**
     * 广播看板
     * 派发状态=“广播中”&&登录人未响应过的派发数据（感兴趣和不感兴趣都算响应）
     *
     * @param query
     * @return
     */
    PagingVO<PmsDistributeVO> broadcastTaskKanban(PmsDistributeQuery query);

    /**
     * 我响应的广播
     * 作为响应资源，对派发对象响应后，会在此页面看到相关的派发数据，同时可以切换是否感兴趣。
     *
     * @param query
     * @return
     */
    PagingVO<PmsDistributeVO> irespondedBroadcast(PmsDistributeQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsDistributeVO}>
     */
    List<PmsDistributeVO> queryListDynamic(PmsDistributeQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsDistributeVO}
     */
    PmsDistributeVO queryByKey(Long key);

    /**
     * 根据 派发类型  和 派发事由ID  查询
     *
     * @param reasonId   派发事由ID
     * @param reasonType 派发类型
     * @return
     */
    PmsDistributeVO queryByReason(Long reasonId, String reasonType);

    List<PmsDistributeVO> queryByReasons(List<Long> reasonIds, String reasonType);


    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);


    /**
     * 流程回调
     *
     * @param payload
     */
    void processStatusChange(ProcessStatusChangePayload payload);

//    /**
//     * 设置接收资源
//     *
//     * @param distId
//     * @param resId
//     */
//    void setReceiverResId(long distId, long resId);

    /**
     * 流程
     *
     * @param payload 单据数据
     */
    void updateWorkFlow(PmsDistributePayload payload);
}
