package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsInspectionItemConfigPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsInspectionItemConfigQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsInspectionItemConfigVO;

import java.util.List;

/**
 * 结项检查项配置
 *
 * @author xxb
 * @date 2023-11-27
 */
public interface PmsInspectionItemConfigService {


    /**
     * 批量保存
     *
     * @param payloads
     */
    void batchSave(List<PmsInspectionItemConfigPayload> payloads);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsInspectionItemConfigVO}>
     */
    PagingVO<PmsInspectionItemConfigVO> queryPaging(PmsInspectionItemConfigQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsInspectionItemConfigVO}>
     */
    List<PmsInspectionItemConfigVO> queryListDynamic(PmsInspectionItemConfigQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsInspectionItemConfigVO}
     */
    PmsInspectionItemConfigVO queryByKey(Long key);


    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 获取结项检查项配置
     *
     * @param workType     工单类型
     * @param approvalNode 审批节点
     */
    List<PmsInspectionItemConfigVO> getListByWorkTypeAndApprovalNode(String workType, String approvalNode);
}
