package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsMaCheckPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsMaCheckQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsMaCheckVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsMaConfigVO;

import java.util.List;

/**
 * 项目经理任务书核对
 *
 * @author carl
 * @date 2023-09-19
 */
public interface PmsMaCheckService {

    /**
     * 新增或修改
     *
     * @param payload 单据数据
     * @return {@link PmsMaCheckVO}
     */
    PmsMaCheckVO insertOrUpdate(PmsMaCheckPayload payload);

    /**
     * 批量新增或修改
     *
     * @param payloads 单据数据
     * @return {@link PmsMaConfigVO}
     */
    void batchInsertOrUpdate(List<PmsMaCheckPayload> payloads);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsMaCheckVO}>
     */
    PagingVO<PmsMaCheckVO> queryPaging(PmsMaCheckQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsMaCheckVO}>
     */
    List<PmsMaCheckVO> queryListDynamic(PmsMaCheckQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsMaCheckVO}
     */
    PmsMaCheckVO queryByKey(Long key);


    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PmsMaCheckPayload payload);


}
