package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsMaConfigDataPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsMaConfigPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsMaConfigQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsMaConfigVO;

import java.util.List;

/**
 * 项目经理任务书配置
 *
 * @author carl
 * @date 2023-09-19
 */
public interface PmsMaConfigService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsMaConfigVO}>
     */
    PagingVO<PmsMaConfigVO> queryPaging(PmsMaConfigQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsMaConfigVO}>
     */
    List<PmsMaConfigVO> queryListDynamic(PmsMaConfigQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsMaConfigVO}
     */
    PmsMaConfigVO queryByKey(Long key);

    /**
     * 批量新增或修改
     *
     * @param payload 单据数据
     * @return {@link PmsMaConfigVO}
     */
    void batchInsertOrUpdate(PmsMaConfigDataPayload payload);

    /**
     * 新增或修改
     *
     * @param payload 单据数据
     * @return {@link PmsMaConfigVO}
     */
    PmsMaConfigVO insertOrUpdate(PmsMaConfigPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PmsMaConfigPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
