package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectBriefPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectBriefQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectBriefVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;

import javax.servlet.http.HttpServletResponse;
import java.time.LocalDate;
import java.util.List;

/**
 * 项目汇报管理
 *
 * @author carl
 * @date 2023-09-05
 */
public interface PmsProjectBriefService {
    /**
     * 获取项目汇报的信息
     *
     * @param projectId
     * @return
     */
    PmsProjectBriefVO queryBriefInfo(Long projectId);

    /**
     * 数据处理
     *
     * @param pmsProjectVO
     * @return
     */
    PmsProjectBriefVO operitonBriefData(PmsProjectVO pmsProjectVO);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsProjectBriefVO}>
     */
    PagingVO<PmsProjectBriefVO> queryPaging(PmsProjectBriefQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectBriefVO}>
     */
    List<PmsProjectBriefVO> queryListDynamic(PmsProjectBriefQuery query);

    /**
     * 批量导出excel
     *
     * @param response 请求响应
     * @param query    查询条件
     */
    void downloadBatch(HttpServletResponse response, PmsProjectBriefQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsProjectBriefVO}
     */
    PmsProjectBriefVO queryByKey(Long key);

    /**
     * 手动汇报 新增或修改
     *
     * @param payload 单据数据
     * @return {@link PmsProjectBriefVO}
     */
    PmsProjectBriefVO insertOrUpdate(PmsProjectBriefPayload payload);

    /**
     * 自动汇报 新增
     *
     * @param payload
     * @return
     */
    PmsProjectBriefVO autoInsert(PmsProjectBriefPayload payload);

//    /**
//     * 修改
//     *
//     * @param payload 单据数据
//     * @return {@link PmsProjectBriefVO}
//     */
//    PmsProjectBriefVO update(PmsProjectBriefPayload payload);
//
//    /**
//     * 修改,置空的字段需需要借助 protected List<String> nullFields;
//     *
//     * @param payload 单据数据
//     * @return {@link long}
//     */
//    long updateByKeyDynamic(PmsProjectBriefPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 流程回调
     *
     * @param payload
     */
    void processStatusChange(ProcessStatusChangePayload payload);

    /**
     * 查询汇报代办
     *
     * @return
     */
    List<PmsProjectBriefVO> projectBriefWork(List<Long> projectIds);

    /**
     * 定时执行自动汇报计划
     */
    void projectBriefJobHandler(String date);

    /**
     * 自动补充历史期间项目汇报
     *
     * @param projectId
     */
    void autoSupplementBierf(Long projectId);

    /**
     * 查询分页权限
     *
     * @param query 查询
     * @return {@link PagingVO}<{@link PmsProjectBriefVO}>
     */
    PagingVO<PmsProjectBriefVO> queryPagingPermission(PmsProjectBriefQuery query);
}
