package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectMembersPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectMembersQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectMembersVO;

import java.util.List;

/**
 * 项目成员
 *
 * @author xxb
 * @date 2023-08-10
 */
public interface PmsProjectMembersService {

    /**
     * 通过项目id查询项目成员 树型
     *
     * @param query 条件
     * @return
     */
    List<PmsProjectMembersVO> queryTreeByProjId(PmsProjectMembersQuery query);

    /**
     * 通过项目id查询项目成员 树型
     *
     * @param query 条件
     * @return
     */
    Long countTreeByProjId(PmsProjectMembersQuery query);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsProjectMembersVO}>
     */
    PagingVO<PmsProjectMembersVO> queryPaging(PmsProjectMembersQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectMembersVO}>
     */
    List<PmsProjectMembersVO> queryListDynamic(PmsProjectMembersQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsProjectMembersVO}
     */
    PmsProjectMembersVO queryByKey(Long key);

    /**
     * 项目成员-新增或修改
     *
     * @param payload 单据数据
     * @return {@link PmsProjectMembersVO}
     */
    PmsProjectMembersVO insertOrUpdate(PmsProjectMembersPayload payload);

    /**
     * 任务派发成功 添加 项目成员
     *
     * @param projId
     * @param resId
     * @return
     */
    PmsProjectMembersVO insertFromTask(Long projId, Long resId);


    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PmsProjectMembersPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
