package com.elitesland.tw.tw5.api.prd.pms.vo;

import cn.zhxu.bs.bean.DbField;
import cn.zhxu.bs.bean.DbIgnore;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 项目活动
 *
 * @author xxb
 * @date 2023-08-17
 */
@Getter
@Setter
public class PmsProjectActivityProcessVO implements Serializable {

    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("项目ID")
    private Long projId;
    @ApiModelProperty("项目编号")
    private String projNo;
    @ApiModelProperty("项目名称")
    private String projName;

    @ApiModelProperty("项目经理资源")
    private String pmResName;
    @ApiModelProperty("销售负责人")
    private String saleManUserName;

    @ApiModelProperty("收款计划")
    private List<ConReceivablePlanVO> planVOS;

    @ApiModelProperty("变更前的活动管理")
    List<PmsProjectActivityVO> preActivityVOS;

    @ApiModelProperty("变更后的活动管理")
    List<PmsProjectActivityVO> activityVOS;
    /**
     * 工作类型
     */
    @ApiModelProperty("工作类型")
    @DbField(mapTo = "scc")
    private String workType;

    @DbIgnore
    @UdcName(udcName = "salecon:work_type", codePropName = "workType")
    private String workTypeDesc;
    /**
     * 合同id
     */
    @ApiModelProperty("合同id")
    private Long contractId;

    /**
     * 平台合同类型
     */
    @ApiModelProperty("平台合同类型")
    private String platType;

    @ApiModelProperty("记录创建者ID")
    private Long createUserId;

    @ApiModelProperty("版本")
    private Integer dataVersion;

    /**
     * 流程定义的KEY
     */
    @ApiModelProperty("流程定义的KEY")
    private String procDefKey;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("活动状态")
    private String activityStatus;

    @ApiModelProperty("变更前活动")
    private String preChangeContent;

    @ApiModelProperty("变更后活动")
    private String changeContent;

}
