package com.elitesland.tw.tw5.api.prd.pms.vo;

import cn.zhxu.bs.bean.DbIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 项目结项
 *
 * @author xxb
 * @date 2023-11-27
 */
@Getter
@Setter
public class PmsProjectConclusionVO extends BaseViewModel implements Serializable {
    /**
     * 异常结项标记
     */
    @ApiModelProperty("异常结项标记")
    private Integer abnormalFlag;
    @UdcName(udcName = "PMS:PROJ_CLOSED:ABNORMAL", codePropName = "abnormalFlag")
    private String abnormalFlagDesc;
    /**
     * 结项状态
     */
    @ApiModelProperty("结项状态")
    private String conclusionStatus;
    @UdcName(udcName = "appr_status", codePropName = "conclusionStatus")
    private String conclusionStatusDesc;

    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    @UdcName(udcName = "appr_status", codePropName = "apprStatus")
    private String apprStatusDesc;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 提交资源userid
     */
    @ApiModelProperty("提交资源userid")
    private Long applyUserId;
    @UdcName(udcName = "USER", codePropName = "applyUserId")
    private String applyUserDesc;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /**
     * 结项检查事项
     */
    @ApiModelProperty("结项检查事项")
    private String conclusionCheckItems;
    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 结项编号
     */
    @ApiModelProperty("结项编号")
    private String conclusionCode;

    @ApiModelProperty("结项审批节点")
    private String approvalNode;


    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projName;

    /**
     * 项目编号
     */
    @ApiModelProperty("项目编号")
    private String projNo;
    /**
     * 项目状态
     */
    @ApiModelProperty("项目状态")
    private String projStatus;
    @UdcName(udcName = "TSK:PROJ_STATUS", codePropName = "projStatus")
    private String projStatusDesc;

    /**
     * 子合同编号
     */
    @ApiModelProperty("子合同编号")
    private String contractNo;

    /**
     * 工作类型
     */
    @ApiModelProperty("工作类型")
    private String workType;
    @UdcName(udcName = "salecon:work_type", codePropName = "workType")
    private String workTypeDesc;

    /**
     * 项目经理资源id
     */
    @ApiModelProperty("项目经理资源id")
    private Long pmResId;
    @UdcName(udcName = "USER", codePropName = "pmResId")
    private String pmResName;
    /**
     * 交付BU_ID
     */
    @ApiModelProperty("交付BU_ID")
    private Long deliBuId;
    /**
     * 交付BU名称
     */
    @UdcName(udcName = "BU", codePropName = "deliBuId")
    private String deliBuName;
    /**
     * 交付用户id
     */
    @ApiModelProperty("交付用户id")
    private Long deliUserId;
    /**
     * 交付用户名称
     */
    @UdcName(udcName = "USER", codePropName = "deliUserId")
    private String deliUserName;

    /**
     * 销售负责人ID
     */
    @ApiModelProperty("销售负责人ID")
    private Long saleManUserId;
    /**
     * 销售负责人名称
     */
    @UdcName(udcName = "USER", codePropName = "saleManUserId")
    private String saleManUserName;

    /**
     * 预算总人天
     */
    @ApiModelProperty("预算总人天")
    private BigDecimal totalDays;
    /**
     * 总当量
     */
    @ApiModelProperty("总当量")
    private BigDecimal totalEqva;

    @ApiModelProperty("总当量总价")
    private BigDecimal totalEqvaAmt;
    /**
     * 费用总预算
     */
    @ApiModelProperty("费用总预算")
    private BigDecimal totalReimbursement;

    /**
     * 费用总成本
     */
    @ApiModelProperty("费用总成本")
    private BigDecimal totalCost;
    /**
     * 预算附件
     */
    @ApiModelProperty("预算附件")
    private String budgetFiles;
    /**
     * 预算附件
     */
    @ApiModelProperty("预算附件")
    private Object budgetFilesData;

    @ApiModelProperty("合同id")
    private Long contractId;

    @ApiModelProperty("平台合同类型")
    private String platType;


    @ApiModelProperty("检查项列表")
    private List<PmsInspectionItemConfigVO> inspectionItemConfigList;


    @ApiModelProperty("项目账号编号")
    private String projAccountNo;
    @ApiModelProperty("项目账号当量余额")
    private BigDecimal projAccountAvalQty;
    @ApiModelProperty("项目账号可用金额")
    private BigDecimal projAccountAvalAmt;
    @ApiModelProperty("项目账号名称")
    private String projAccountName;


    @ApiModelProperty("交付BU账号编号")
    private String buAccountNo;
    @ApiModelProperty("交付BU账号名称")
    private String buAccountName;


    @ApiModelProperty("产品大类")
    private String productClass;
    @ExcelProperty(index = 20, value = "产品大类")
    @UdcName(udcName = "con:sales_class", codePropName = "productClass")
    private String productClassDesc;
    /**
     * 产品小类
     */
    @ApiModelProperty("产品小类")
    private String productSubClass;
    private String productSubClassDesc;

    /**
     * 当量预估单价
     */
    @ApiModelProperty("当量预估单价")
    private BigDecimal eqvaPrice;
    /**
     * 项目经理当量系数
     */
    @ApiModelProperty("项目经理当量系数")
    private BigDecimal pmEqvaRatio;


    @ApiModelProperty("节点操作详情")
    private String approvalNodeInfo;


    /**
     * 1、交付项目、自主研发 是根据按钮“收入确认”提交的时间
     *
     * 2、其他项目 的收入确认时间 取结项申请日期  、创建人提交日期
     */
    @ApiModelProperty("收入确认日期")
    private LocalDateTime jdeConfirmTime;
}
