package com.elitesland.tw.tw5.api.prd.pms.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 事由号当量信息
 *
 * @author carl
 * @date 2023/10/12
 */
@Data
public class PmsReasonEqvaVO {

    /**
     * 负责人Id
     */
    @ApiModelProperty("负责人Id")
    private Long managerUserId;

    /**
     * 事由类型
     * <p>
     * 枚举 TskEnums.TaskReasonType
     * <p>
     * "01", "项目"
     * "02", "售前"
     * "03", "BU"
     * "04", "采购"
     */
    @ApiModelProperty("事由类型")
    private String reasonType;

    /**
     * 事由Id
     */
    @ApiModelProperty("事由Id")
    private Long reasonId;

    /**
     * 事由名称
     */
    @ApiModelProperty("事由名称")
    private String reasonName;

    /**
     * 项目总预算当量
     */
    @ApiModelProperty("项目总预算当量")
    private BigDecimal budgetEqva = BigDecimal.ZERO;

    /**
     * 拨付的当量
     */
    @ApiModelProperty("拨付的当量")
    private BigDecimal appropriationEqva = BigDecimal.ZERO;

    /**
     * 已派发任务包当量（已派发任务包当量）
     */
    @ApiModelProperty("已派发任务包当量（已派发任务包当量）")
    private BigDecimal distedEqva = BigDecimal.ZERO;

    /**
     * 已授权当量
     */
    @ApiModelProperty("已授权当量")
    private BigDecimal authedEqva = BigDecimal.ZERO;

    /**
     * 已授权当量中 派发出去的当量
     */
    @ApiModelProperty("已授权当量中 派发出去的当量")
    private BigDecimal authedDistedEqva = BigDecimal.ZERO;

    /**
     * 可用当量
     */
    @ApiModelProperty("可用当量")
    private BigDecimal availabledEqva = BigDecimal.ZERO;

    /**
     * 已结算当量
     */
    @ApiModelProperty("已结算当量")
    private BigDecimal settledEqva = BigDecimal.ZERO;
}
