package com.elitesland.tw.tw5.api.prd.product.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.product.payload.PrdProductCasePayload;
import com.elitesland.tw.tw5.api.prd.product.query.PrdProductCaseQuery;
import com.elitesland.tw.tw5.api.prd.product.vo.PrdProductCaseVO;

import java.util.List;

/**
 * 产品成功案例
 *
 * @author likunpeng
 * @date 2023-05-22
 */
public interface PrdProductCaseService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PrdProductCaseVO}>
     */
    PagingVO<PrdProductCaseVO> queryPaging(PrdProductCaseQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PrdProductCaseVO}>
     */
    List<PrdProductCaseVO> queryListDynamic(PrdProductCaseQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PrdProductCaseVO}
     */
    PrdProductCaseVO queryByKey(Long key);

    /**
     * 产品成功案例-产品id查询
     *
     * @param prodId 主键
     * @return {@link PrdProductCaseVO}
     */
    List<PrdProductCaseVO> queryByProductKey(Long prodId);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PrdProductCaseVO}
     */
    PrdProductCaseVO insert(PrdProductCasePayload payload);

    /**
     * 新增
     *
     * @param list 集合
     * @return {@link PrdProductCaseVO}
     */
    List<PrdProductCaseVO> insertAll(List<PrdProductCasePayload> list);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PrdProductCaseVO}
     */
    PrdProductCaseVO update(PrdProductCasePayload payload);

    /**
     * 修改
     *
     * @param payloads 集合
     * @return {@link PrdProductCaseVO}
     */
    List<PrdProductCaseVO> updateAll(List<PrdProductCasePayload> payloads);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
