package com.elitesland.tw.tw5.api.prd.product.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.product.payload.PrdProductClassPayload;
import com.elitesland.tw.tw5.api.prd.product.query.PrdProductClassQuery;
import com.elitesland.tw.tw5.api.prd.product.vo.PrdProductClassVO;

import java.util.List;

/**
 * 产品分类
 *
 * @author likunpeng
 * @date 2023-05-22
 */
public interface PrdProductClassService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PrdProductClassVO}>
     */
    PagingVO<PrdProductClassVO> queryPaging(PrdProductClassQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PrdProductClassVO}>
     */
    List<PrdProductClassVO> queryListDynamic(PrdProductClassQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PrdProductClassVO}
     */
    PrdProductClassVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PrdProductClassVO}
     */
    PrdProductClassVO insert(PrdProductClassPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PrdProductClassVO}
     */
    PrdProductClassVO update(PrdProductClassPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 产品分类-通过上级查询小类
     *
     * @param seniorId 上级id
     * @return
     */
    List<PrdProductClassVO> querySubClassBySeniorId(Long seniorId);
    List<PrdProductClassVO> getClassTrees(Long pId);

}
